<?php

namespace BetterLinksPro\Traits;

trait UTM {
	/**
	 * Get UTM template
	 *
	 * @param array  $templates Array of template names.
	 * @param string $template_name Search template name.
	 */
	private function get_template( $templates, $template_name ) {
		$template_name_arr = array_column( $templates, 'template_name' );
		return array_search( $template_name, $template_name_arr, true );
	}

	/**
	 * Check UTM template exists or not
	 *
	 * @param array  $templates Array of template names.
	 * @param string $template_name Search template name.
	 *
	 * @return boolean Returns true if template exists, false otherwise.
	 */
	private function check_template_exists( $templates, $template_name ) {
		$template_index = $this->get_template( $templates, $template_name );
		return false !== $template_index;
	}

	/**
	 * Check UTM campaign exists or not
	 *
	 * @param array  $templates Array of template names.
	 * @param string $campaign_name Search template name.
	 */
	private function check_campaign_exists( $templates, $campaign_name ) {
		$template_name_arr = array_column( $templates, 'utm_campaign' );
		return array_search( $campaign_name, $template_name_arr, true ) !== false;
	}

	/**
	 * Check if the fields already exist
	 *
	 * @param array  $templates Array of templates.
	 * @param string $campaign_name.
	 * @param string $template_name.
	 *
	 * @return boolean|array Returns false if fields not exist, otherwise returns appropriate message in an array.
	 */
	public function check_fields_exists( $templates, $utm_campaign, $template_name ) {
		// Check if t campaign empty.
		if ( '' === $utm_campaign ) {
			return array(
				'success' => false,
				'message' => esc_html__( 'Campaign field is empty', 'betterlinks-pro' ),
			);
		}

		// 👇 check if the campaign is already exists.
		$is_campaign_exists = $this->check_campaign_exists( $templates, $utm_campaign );
		if ( $is_campaign_exists ) {
			return array(
				'message'    => esc_html__( 'Campaign already exists', 'betterlinks-pro' ),
				'field_name' => 'utm_campaign',
			);
		}

		// 👇 check if the template is already exists.
		$is_template_exists = $this->check_template_exists( $templates, $template_name );
		if ( $is_template_exists ) {
			return array(
				'message'    => esc_html__( 'Template already exists', 'betterlinks-pro' ),
				'field_name' => 'template_name',
			);
		}
		return false;
	}
}
