<?php
namespace BetterLinksPro\Traits;

trait ArgumentSchema {

	public function utm_schema() {
		return apply_filters(
			'betterlinks/utm_schema',
			array(
				'template_name' => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'utm_source'    => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'utm_medium'    => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'utm_campaign'  => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'utm_term'      => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'utm_content'   => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
			)
		);
	}

	public function get_utm_schema() {
		return $this->utm_schema();
	}

	public function get_keywords_schema() {
		return apply_filters(
			'betterlinks/keywords_schema',
			array(
				'keywords'       => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'link_id'        => array(
					'type'              => 'integer',
					'sanitize_callback' => 'absint',
				),
				'post_type'      => array(
					'type'  => 'array',
					'items' => array(
						'type' => 'string',
					),
				),
				'category'       => array(
					'type'  => 'array',
					'items' => array(
						'type' => 'string',
					),
				),
				'tags'           => array(
					'type'  => 'array',
					'items' => array(
						'type' => 'string',
					),
				),
				'open_new_tab'   => array(
					'type'              => 'integer',
					'sanitize_callback' => 'absint',
				),
				'use_no_follow'  => array(
					'type'              => 'integer',
					'sanitize_callback' => 'absint',
				),
				'case_sensitive' => array(
					'type'              => 'integer',
					'sanitize_callback' => 'absint',
				),
				'left_boundary'  => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'right_boundary' => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'keyword_before' => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'keyword_after'  => array(
					'type'              => 'string',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'limit'          => array(
					'type'              => 'integer',
					'sanitize_callback' => 'absint',
				),
				'priority'       => array(
					'type'              => 'integer',
					'sanitize_callback' => 'absint',
				),
			)
		);
	}
}
