<?php
namespace BetterLinksPro;

use BetterLinks\Admin\Cache;
use BetterLinksPro\Traits\DBTables;
class Migration {
	use DBTables;

	public static function init() {
		global $wpdb;
		// update plugin version
		if ( get_option( 'betterlinks_pro_version' ) !== BETTERLINKS_PRO_VERSION ) {
			if ( class_exists( '\BetterLinks\Helper' ) ) {
				\BetterLinks\Helper::create_cron_jobs_for_json_links();
			}

			if ( version_compare( BETTERLINKS_PRO_VERSION, '1.7.0', '>' ) ) {
				( new self() )->modifyBetterLinksClicksTable();
			}

			if ( version_compare( BETTERLINKS_PRO_VERSION, '1.8.0', '>=' ) ) {
				( new self() )->createBetterLinkCustomizeMetaTagsTable();
			}

			if ( version_compare( BETTERLINKS_PRO_VERSION, '2.1.0', '>=' ) ) {
				$betterlinkspro_ga = get_option( BETTERLINKS_PRO_EXTERNAL_ANALYTICS_OPTION_NAME, [] );
				if ( is_string( $betterlinkspro_ga ) ) {
					$betterlinkspro_ga = json_decode( $betterlinkspro_ga, true );
				}
				if( !is_array( $betterlinkspro_ga ) ) {
					$betterlinkspro_ga = [];
				}
				if ( empty( $betterlinkspro_ga['parameter_tracking'] ) ) {
					$betterlinkspro_ga['parameter_tracking'] = [];
					$betterlinkspro_ga['parameter_tracking'] = array(
						'pf'         => 1,
						'target_url' => 0,
						'utm'        => 0,
					);
					update_option( BETTERLINKS_PRO_EXTERNAL_ANALYTICS_OPTION_NAME, $betterlinkspro_ga );
				}

				if( version_compare( BETTERLINKS_PRO_VERSION, '2.1.2', '>=' ) ){
					delete_transient('betterlinks_pro_software__license_data');
				}
			}
			/**
			 * License Migration
			 */
			self::license_migration();

			update_option( 'betterlinks_pro_version', BETTERLINKS_PRO_VERSION );
		}
		if ( ! get_option( BETTERLINKS_PRO_EXTERNAL_ANALYTICS_OPTION_NAME ) ) {
			add_option(
				BETTERLINKS_PRO_EXTERNAL_ANALYTICS_OPTION_NAME,
				array(
					'is_enable_ga'       => false,
					'ga_tracking_code'   => '',
					'parameter_tracking' => array(
						'pf'         => 1,
						'target_url' => 0,
						'utm'        => 0,
					),
				)
			);
		}
		$wpdb->query( "DELETE FROM {$wpdb->prefix}options WHERE option_name IN( 'betterlinks_autolink_options' )" );
	}

	private static function license_migration() {
		$license_key = get_option( BETTERLINKS_PRO_PLUGIN_SLUG . '-license-key', false );

		if ( $license_key !== false ) {
			$license_status = get_option( BETTERLINKS_PRO_PLUGIN_SLUG . '-license-status' );
			$license_data   = get_transient( BETTERLINKS_PRO_PLUGIN_SLUG . '-license_data' );

			update_option( BETTERLINKS_PRO_SL_DB_PREFIX . '_license', $license_key, 'no' );
			update_option( BETTERLINKS_PRO_SL_DB_PREFIX . '_license_status', $license_status, 'no' );
			set_transient( BETTERLINKS_PRO_SL_DB_PREFIX . '_license_data', $license_data, MONTH_IN_SECONDS * 3 );
		}
	}
}
