<?php
namespace BetterLinksPro;

use WP_Http;

class Link {
	private static $link_options;

	public static function init() {
		$self = new self();
		add_filter( 'betterlinks/link/get_link_by_slug', array( $self, 'get_link_by_slug' ) );
		add_action( 'betterlinks/pre_before_redirect', array( $self, 'pre_before_redirect' ) );
		add_action( 'betterlinks/before_redirect', array( $self, 'before_redirect' ) );
		add_filter( 'betterlinks/link/before_dispatch_redirect', array( $self, 'before_dispatch_redirect' ) );
		add_filter( 'betterlinks/link/target_url', array( $self, 'target_url' ) );
		add_filter( 'betterlinks/is_password_protected_redirect_compatible', '__return_true' );
		add_filter( 'betterlinks/site_url', array( $self, 'modify_site_url' ) );

		add_filter( 'betterlinks_before_cle', array( $self, 'before_cle' ), 10, 2 ); // before Create Link Externally
		// analytic
		add_action( 'betterlinks/link/before_start_tracking', array( $self, 'before_start_tracking' ) );
		add_action( 'betterlinks/link/after_insert_click', array( $self, 'after_insert_click' ), 10, 3 );
		add_filter( 'betterlinks/link/insert_click_arg', array( $self, 'rotation_target_url_set' ), 10, 2 );
		// cloaked link redirect
		add_action( 'betterlinks/make_cloaked_redirect', array( $self, 'make_cloaked_redirect' ), 10, 2 );
		add_action( 'btl_header_redirect', array( $self, 'btl_header_redirect' ), 10, 2 );

		// fetching betterlinks settings
		$settings = get_option( 'betterlinks_links', true );
		if ( is_string( $settings ) ) {
			$settings = json_decode( $settings, true );
		}
		$self::$link_options = $settings;
	}
	
	public function modify_site_url() {
		$settings = get_option( BETTERLINKS_LINKS_OPTION_NAME, '[]' );
		if ( is_string( $settings ) ) {
			$settings = json_decode( $settings, true );
		}

		if( empty( $settings['custom_domain']['enable_shortlink_custom_domain'] ) ){
			return site_url();
		}
		
		return wp_unslash( $settings['custom_domain']['shortlink_custom_domain'] );
	}

	public function before_cle( $initial_values, $settings ) {
		if ( empty( $settings['cle']['advanced_options'] ) ) {
			return $initial_values;
		}

		$cle_options = $settings['cle'];
		$advanced_cle_values = array(
			'cat_id'           => ! empty( $cle_options['category'] ) ? sanitize_text_field( $cle_options['category'] ) : 1,
			'redirect_type'    => ! empty( $cle_options['redirect_type'] ) ? sanitize_text_field( $cle_options['redirect_type'] ) : '307',
			'nofollow'         => ! empty( $cle_options['no_follow'] ) ? sanitize_text_field( $cle_options['no_follow'] ) : '',
			'sponsored'        => ! empty( $cle_options['sponsored'] ) ? sanitize_text_field( $cle_options['sponsored'] ) : '',
			'param_forwarding' => ! empty( $cle_options['param_forwarding'] ) ? sanitize_text_field( $cle_options['param_forwarding'] ) : '',
			'track_me'         => ! empty( $cle_options['track_me'] ) ? sanitize_text_field( $cle_options['track_me'] ) : '',
			'social_share'     => ! empty( $cle_options['social_share'] ) ? sanitize_text_field( $cle_options['social_share'] ) : '',
			'pro_enabled'      => true,
		);
		return wp_parse_args( $advanced_cle_values, $initial_values );
	}

	public function btl_header_redirect( $id ) {
		$betterlinkspro_options   = get_option( BETTERLINKS_PRO_EXTERNAL_ANALYTICS_OPTION_NAME );
		$is_enable_custom_scripts = isset( $betterlinkspro_options['is_enable_custom_scripts'] ) ? $betterlinkspro_options['is_enable_custom_scripts'] : false;
		$global_head_scripts      = isset( $betterlinkspro_options['global_head_scripts'] ) ? $betterlinkspro_options['global_head_scripts'] : '';
		$global_head_scripts      = preg_replace( '/\\\\/', '', $global_head_scripts );

		if ( ! empty( $is_enable_custom_scripts ) && ! empty( $global_head_scripts ) ) {
			echo stripslashes( $global_head_scripts );
		}

		$custom_tracking_scripts = \BetterLinks\Helper::get_link_meta( $id, 'btl_custom_tracking_scripts' );
		if ( empty( $custom_tracking_scripts ) ) {
			return;
		}

		$custom_tracking_scripts = unserialize( $custom_tracking_scripts );
		$tracking_script         = isset( $custom_tracking_scripts['script'] ) ? stripslashes( $custom_tracking_scripts['script'] ) : false;
		if ( $tracking_script ) {
			echo $tracking_script;
		}
	}

	public function get_link_by_slug( $link ) {
		if ( isset( $link['expire'] ) && Helper::is_json( $link['expire'] ) ) {
			$link['expire'] = json_decode( $link['expire'], true );
		}
		if ( isset( $link['dynamic_redirect'] ) && Helper::is_json( $link['dynamic_redirect'] ) ) {
			$link['dynamic_redirect'] = json_decode( $link['dynamic_redirect'], true );
		}
		return $link;
	}
	public function before_redirect( $data ) {
		if ( isset( $data['expire'] ) && ! is_array( $data['expire'] ) ) {
			$data['expire'] = json_decode( $data['expire'], true );
		}
		if ( 'publish' === $data['link_status'] && isset( $data['expire']['status'] ) && true === (bool)$data['expire']['status'] ) {
			wp_schedule_single_event( time(), 'betterlinkspro/expire_link_status_handler', array( $data ) );
			(new WP_Http)->request(site_url('wp-cron.php'));
		}
		// Set up visitor id for tracking
		$visitor_cookie = 'betterlinks_visitor';
		if ( ! isset( $_COOKIE[ $visitor_cookie ] ) ) {
			$visitor_cookie_expire_time = time() + 60 * 60 * 24 * 365; // 1 year
			$visitor_uid                = uniqid( 'bl' );
			setcookie( $visitor_cookie, $visitor_uid, $visitor_cookie_expire_time, '/' );
		}
		$this->start_external_analytics_cron_job( $data );

		// 👇 checking link is protected or not.
		$data['is_protected'] = false;
		if ( class_exists( '\BetterLinksPro\Helper' ) ) {
			// Redirect to Customized Meta Tag template, if meta customization is enabled.
			if ( ! empty( self::$link_options['enable_customize_meta_tags'] ) ) {
				$enable_meta = Helper::check_meta_tag_enable_by_link_id( $data['ID'] );
				if ( $enable_meta && $data['is_bot'] ) {
					wp_safe_redirect( esc_url_raw( site_url() . '/customized-meta-tags/?short_url=' . esc_attr( $data['short_url'] ) ) );
					exit();
				}
			}

			// Fetching password credentials, if available.
			if ( ! empty( self::$link_options['enable_password_protection'] ) && empty( $data['skip_password_protection'] ) ) {
				$password = Helper::get_password_by_link_id( $data['ID'] );
				if ( count( $password ) > 0 ) {
					// $data['is_protected'] = '1' === $password[0]->status;
					if( '1' === $password[0]->status ) {
						$form_link = get_permalink( get_page_by_path( 'password-protected-form' ) );
						wp_redirect( esc_url_raw( $form_link . '?short_url=' . esc_attr( $data['short_url'] ) ) );
						exit();
					}
				}
			}
		}
	}

	public function start_external_analytics_cron_job( $data ) {
		$ga_tracking_code   = false;
		$ga4_api_secret     = false;
		$pixel_id           = false;
		$pixel_access_token = false;
		$visitor = self::setup_ga_cookie();

		if ( BETTERLINKS_EXISTS_LINKS_JSON ) {
			global $betterlinks;
			if ( ! empty( $betterlinks['is_enable_ga'] ) && ! empty( $betterlinks['ga_tracking_code'] ) ) {
				$ga_tracking_code = $betterlinks['ga_tracking_code'];
			}
			if ( ! empty( $betterlinks['is_enable_ga'] ) && ! empty( $betterlinks['is_ga4'] ) && ! empty( $betterlinks['ga4_api_secret'] ) ) {
				$ga4_api_secret = $betterlinks['ga4_api_secret'];
			}
			if ( ! empty( $betterlinks['is_enable_pixel'] ) && ! empty( $betterlinks['pixel_id'] ) && ! empty( $betterlinks['pixel_access_token'] ) ) {
				$pixel_id           = $betterlinks['pixel_id'];
				$pixel_access_token = $betterlinks['pixel_access_token'];
			}
		} else {
			$analytic_options = get_option( BETTERLINKS_PRO_EXTERNAL_ANALYTICS_OPTION_NAME, array() );
			if ( is_string( $analytic_options ) ) {
				$analytic_options = json_decode( $analytic_options, true );
			}
			if ( ! empty( $analytic_options['is_enable_ga'] ) && ! empty( $analytic_options['ga_tracking_code'] ) ) {
				$ga_tracking_code = $analytic_options['ga_tracking_code'];
			}
			if ( ! empty( $analytic_options['is_enable_ga'] ) && ! empty( $analytic_options['is_ga4'] ) && ! empty( $analytic_options['ga4_api_secret'] ) ) {
				$ga4_api_secret = $analytic_options['ga4_api_secret'];
			}
			if ( ! empty( $analytic_options['is_enable_pixel'] ) && ! empty( $analytic_options['pixel_id'] ) && ! empty( $analytic_options['pixel_access_token'] ) ) {
				$pixel_id           = $analytic_options['pixel_id'];
				$pixel_access_token = $analytic_options['pixel_access_token'];
			}
		}

		if ( $ga_tracking_code ) {
			$request_uri = !empty( $data['location'] ) ? esc_url_raw( $data['location'] ) : '';
			if( empty( $request_uri ) ){
				$request_uri = isset( $_SERVER['REQUEST_URI'] ) ? wp_unslash( $_SERVER['REQUEST_URI'] ) : '';
			}
			wp_schedule_single_event( time(), 'betterlinkspro/send_google_analytics_data', array( $data, $request_uri, $ga_tracking_code, $ga4_api_secret, $visitor ) );
		}

		if ( $pixel_id && $pixel_access_token ) {
			wp_schedule_single_event( time(), 'betterlinkspro/send_pixel_analytics_data', array( $data, $_SERVER, $pixel_id, $pixel_access_token ) );
		}
	}

	public function pre_before_redirect( $data ) {
		if ( isset( $data['link_status'] ) && ( 'draft' === $data['link_status'] || 'scheduled' === $data['link_status'] ) ) {
			return false;
		}
		return true;
	}
	public function before_dispatch_redirect( $data ) {
		if ( isset( $data['expire'] ) && ! is_array( $data['expire'] ) ) {
			$data['expire'] = json_decode( $data['expire'], true );
		}
		if ( 'expired' === $data['link_status'] ) {
			if ( isset( $data['expire'] ) && filter_var( $data['expire']['status'], FILTER_VALIDATE_BOOLEAN ) == true && isset( $data['expire']['redirect_status'] ) && filter_var( $data['expire']['redirect_status'], FILTER_VALIDATE_BOOLEAN ) == true ) {
				$data['target_url'] = $data['expire']['redirect_url'];
				return $data;
			}
			return;
		}
		// dynamic redirect
		if ( isset( $data['dynamic_redirect'] ) && ! empty( $data['dynamic_redirect'] ) ) {
			if ( $data['dynamic_redirect']['type'] == 'rotation' ) {
				if ( is_array( $data['dynamic_redirect']['value'] ) ) {
					$index = ( $data['dynamic_redirect']['extra']['rotation_mode'] == 'random' ? rand( 0, count( $data['dynamic_redirect']['value'] ) - 1 ) : (int) $this->random_weight_index( $data['dynamic_redirect']['value'] ) );
					if ( isset( $data['dynamic_redirect']['value'][ $index ]['link'] ) ) {
						$data['target_url'] = $data['dynamic_redirect']['value'][ $index ]['link'];
					}
				}
			} elseif ( $data['dynamic_redirect']['type'] == 'geographic' ) {
				$country_code = Helper::get_country_code();
				if ( is_array( $data['dynamic_redirect']['value'] ) ) {
					foreach ( $data['dynamic_redirect']['value'] as $item ) {
						if ( isset( $item['country'] ) && is_array( $item['country'] ) && in_array( $country_code, $item['country'] ) ) {
							$data['target_url'] = $item['link'];
							break;
						}
					}
				}
			} elseif ( $data['dynamic_redirect']['type'] == 'technology' ) {
				$client_info = Helper::get_client_info();
				if ( is_array( $client_info ) && is_array( $data['dynamic_redirect']['value'] ) ) {
					foreach ( $data['dynamic_redirect']['value'] as $item ) {
						if (
							( ! isset( $item['device'] ) || ( $item['device'] == 'any' || stripos( $client_info['device'], $item['device'] ) !== false ) ) &&
							( ! isset( $item['browser'] ) || ( $item['browser'] == 'any' || stripos( $client_info['browser'], $item['browser'] ) !== false ) ) &&
							( ! isset( $item['os'] ) || ( stripos( $client_info['os'], $item['os'] ) !== false ) )
						) {
							$data['target_url'] = $item['link'];
							break;
						}
					}
				}
			} elseif ( $data['dynamic_redirect']['type'] == 'time' ) {
				if ( is_array( $data['dynamic_redirect']['value'] ) ) {
					$local_time = current_datetime();
					$now        = $local_time->getTimestamp() + $local_time->getOffset();
					$offset     = (float) get_option( 'gmt_offset' );
					foreach ( $data['dynamic_redirect']['value'] as $item ) {
						if ( isset( $item['start_date'] ) && isset( $item['end_date'] ) ) {
							if ( Helper::check_in_range( $item['start_date'] . ' ' . $offset . ' hours', $item['end_date'] . ' ' . $offset . ' hours', $now ) ) {
								$data['target_url'] = $item['link'];
								break;
							}
						}
					}
				}
			}
		}
		return $data;
	}

	public function random_weight_index( $data ) {
		$r      = mt_rand( 1, 1000 );
		$offset = 0;
		foreach ( $data as $k => $item ) {
			$offset += $item['weight'] * 10;
			if ( $r <= $offset ) {
				return $k;
			}
		}
	}

	public function after_insert_click( $link_id, $click_id, $target_url ) {
		$link = current( \BetterLinks\Helper::get_link_by_ID( $link_id ) );
		if ( isset( $link['dynamic_redirect'] ) && Helper::is_json( $link['dynamic_redirect'] ) ) {
			$dynamic_redirect = (array) json_decode( $link['dynamic_redirect'], true );
			if ( isset( $dynamic_redirect['type'] ) &&
				$dynamic_redirect['type'] == 'rotation' &&
				isset( $dynamic_redirect['extra']['split_test'] ) &&
				filter_var( $dynamic_redirect['extra']['split_test'], FILTER_VALIDATE_BOOLEAN ) == true
			) {
				Helper::insert_click_rotation(
					array(
						'link_id'    => $link_id,
						'click_id'   => $click_id,
						'target_url' => $target_url,
					)
				);
			}
		}
	}

	public function before_start_tracking( $data ) {
		if ( isset( $data['dynamic_redirect'] ) ) {
			if ( Helper::is_json( $data['dynamic_redirect'] ) ) {
				$dynamic_redirect = json_decode( $data['dynamic_redirect'], true );
			} else {
				$dynamic_redirect = $data['dynamic_redirect'];
			}
			if ( isset( $dynamic_redirect['type'] ) && $dynamic_redirect['type'] == 'rotation' && $dynamic_redirect['extra']['split_test'] == true ) {
				if ( isset( $dynamic_redirect['extra']['goal_link'] ) ) {
					// Set Cookie if it doesn't exist
					$cookie_name = 'betterlinks_pro_goal_link_' . $dynamic_redirect['extra']['goal_link'];
					// Used for unique click tracking
					$cookie_expire_time = time() + 60 * 60 * 24 * 7; // Expire in 7 days
					if ( ! isset( $_COOKIE[ $cookie_name ] ) ) {
						setcookie( $cookie_name, $data['target_url'], $cookie_expire_time, '/' );
					}
				}
			}
		}
	}

	public function rotation_target_url_set( $arg ) {
		$cookie_name = 'betterlinks_pro_goal_link_' . $arg['link_id'];
		if ( isset( $_COOKIE[ $cookie_name ] ) ) {
			$cookie_value = $_COOKIE[ $cookie_name ];
			if ( setcookie( $cookie_name, 0, time() - 3600, '/' ) ) {
				$arg['rotation_target_url'] = $cookie_value;
			}
		}
		return $arg;
	}
	public static function target_url( $url ) {
		global $betterlinks;
		if ( isset( $betterlinks['force_https'] ) && $betterlinks['force_https'] ) {
			return preg_replace( '/^http:/i', 'https:', $url );
		}
		return $url;
	}
	public static function make_cloaked_redirect( $target_url, $data ) {
		header( 'Content-Type: text/html' );
		global $wpdb;
		$prefix    = $wpdb->prefix;
		$query     = $wpdb->prepare( "SELECT ID, link_title,link_note FROM {$prefix}betterlinks WHERE ID = %d", $data['ID'] );
		$curr_item = current( $wpdb->get_results( $query, ARRAY_A ) );
		require_once BETTERLINKS_PRO_ROOT_DIR_PATH . '/includes/cloaked.php';
	}

	public static function get_password_protection_status() {
		return ! empty( self::$link_options['password'] ) ? self::$link_options['password'] : null;
	}

	public static function setup_ga_cookie() {
		// Set up visitor id for tracking
		$visitor_cookie = '_ga';
		if ( ! isset( $_COOKIE[ $visitor_cookie ] ) ) {
			$visitor_cookie_expire_time = time() + 60 * 60 * 24 * 365; // 1 year
			// $visitor_uid                = uniqid( 'bl' );
			$visitor_uid = (new self())->gaCookieGeneration( site_url());
			setcookie( $visitor_cookie, $visitor_uid, $visitor_cookie_expire_time, '/' );
			return $visitor_uid;
		}
		return $_COOKIE[ $visitor_cookie ];
	}

	public function gaCookieGeneration($domain, $version = 1, $rootpath = '/') {
		// Count subdomains
		$subdomains = substr_count($domain, '.') + 1;
	
		// Count directories in root path
		$rootpathDirs = substr_count($rootpath, '/');
		$cookiePath = $rootpathDirs > 1 ? "-$rootpathDirs" : '';
	
		// Generate unique ID and timestamp
		$uniqueId = substr(str_replace('.', '', uniqid('', true)), 0, 9);
		$timeStamp = substr(time(), 0, 10);
	
		// Return GA cookie format
		return "GA{$version}.{$subdomains}{$cookiePath}.{$uniqueId}.{$timeStamp}";
	}

}
