<?php
// @-collapse
namespace BetterLinksPro;

// use BetterLinks\Traits\Clicks;

class Helper {
	// use Clicks;

	private static $transient_timeout = MINUTE_IN_SECONDS * 30;
	
	public static function get_all_roles() {
		global $wp_roles;
		$all_roles = $wp_roles->roles;
		unset( $all_roles['administrator'] );
		return wp_list_pluck( $all_roles, 'name' );
	}
	public static function current_user_can_do( $role, $user, $userPermission ) {
		if ( current_user_can( 'manage_options' ) ) {
			return true;
		}
		$current_user_roles = current( $user->roles );

		if ( isset( $userPermission[ $role ] ) && in_array( $current_user_roles, $userPermission[ $role ] ) ) {
			return true;
		}
		return false;
	}

	public static function is_json( $string, $return_data = false ) {
		if ( is_array( $string ) ) {
			return false;
		}
		$data = json_decode( $string );
		return ( json_last_error() == JSON_ERROR_NONE ) ? ( $return_data ? $data : true ) : false;
	}

	public static function get_current_client_ip() {
		$ipaddress = '';
		if ( isset( $_SERVER['HTTP_CLIENT_IP'] ) && $_SERVER['HTTP_CLIENT_IP'] != '127.0.0.1' ) {
			$ipaddress = sanitize_text_field( $_SERVER['HTTP_CLIENT_IP'] );
		} elseif ( isset( $_SERVER['HTTP_X_FORWARDED_FOR'] ) && $_SERVER['HTTP_X_FORWARDED_FOR'] != '127.0.0.1' ) {
			$ipaddress = sanitize_text_field( $_SERVER['HTTP_X_FORWARDED_FOR'] );
		} elseif ( isset( $_SERVER['HTTP_X_FORWARDED'] ) && $_SERVER['HTTP_X_FORWARDED'] != '127.0.0.1' ) {
			$ipaddress = sanitize_text_field( $_SERVER['HTTP_X_FORWARDED'] );
		} elseif ( isset( $_SERVER['HTTP_FORWARDED_FOR'] ) && $_SERVER['HTTP_FORWARDED_FOR'] != '127.0.0.1' ) {
			$ipaddress = sanitize_text_field( $_SERVER['HTTP_FORWARDED_FOR'] );
		} elseif ( isset( $_SERVER['HTTP_FORWARDED'] ) && $_SERVER['HTTP_FORWARDED'] != '127.0.0.1' ) {
			$ipaddress = sanitize_text_field( $_SERVER['HTTP_FORWARDED'] );
		} elseif ( isset( $_SERVER['REMOTE_ADDR'] ) && $_SERVER['REMOTE_ADDR'] != '127.0.0.1' ) {
			$ipaddress = sanitize_text_field( $_SERVER['REMOTE_ADDR'] );
		}
		$ipaddress = explode( ',', $ipaddress )[0];
		return filter_var( $ipaddress, FILTER_VALIDATE_IP ) ? $ipaddress : null;
	}
	public static function get_country_code() {
		$ip           = self::get_current_client_ip();
		$country_code = get_transient( 'betterlinkspro' . $ip );
		if ( $country_code ) {
			return $country_code;
		} else {
			$apiUrl       = "http://api.ipstack.com/{$ip}?access_key=f4bcd16337bcc4911160fe764234b057";
			$response     = wp_remote_get( $apiUrl );
			$responseBody = wp_remote_retrieve_body( $response );
			$result       = json_decode( $responseBody, true );
			if ( is_array( $result ) && isset( $result['country_code'] ) && ! is_wp_error( $responseBody ) ) {
				set_transient( 'betterlinkspro' . $ip, $result['country_code'], DAY_IN_SECONDS );
				return $result['country_code'];
			}
		}
		return;
	}
	public static function get_client_info() {
		$useragent = ( isset( $_SERVER['HTTP_USER_AGENT'] ) ? sanitize_text_field( $_SERVER['HTTP_USER_AGENT'] ) : '' );
		if ( $useragent ) {
			$Browser = new Lib\BrowserDetection();
			return array(
				'browser' => $Browser->getBrowser( $useragent )['browser_name'],
				'os'      => $Browser->getOS( $useragent )['os_name'],
				'device'  => $Browser->getDevice( $useragent )['device_type'],
			);
		}
		return;
	}

	public static function check_in_range( $start_date, $end_date, $date_from_user ) {
		// Convert to timestamp
		$start = strtotime( $start_date );
		$end   = strtotime( $end_date );
		$check = is_numeric( $date_from_user ) ? $date_from_user : strtotime( $date_from_user );
		// Check that user date is between start & end
		return ( ( $start <= $check ) && ( $check <= $end ) );
	}
	public static function addScheme( $url, $scheme = 'http://' ) {
		if ( strpos( $url, '/' ) === 0 ) {
			return $url = site_url( '/' ) . $url;
		}
		return apply_filters( 'betterlinks/link/target_url', parse_url( $url, PHP_URL_SCHEME ) === null ? $scheme . $url : $url );
	}
	public static function url_http_response_is_broken( $url, $args = array() ) {
		try {
			$options    = array(
				'headers'         => array(
					'User-Agent' => $_SERVER['HTTP_USER_AGENT'],
				),
				'http_errors'     => false,
				'verify'          => false,
				'connect_timeout' => isset( $args['connect_timeout'] ) ? $args['connect_timeout'] : 30.0,
				'timeout'         => isset( $args['timeout'] ) ? $args['timeout'] : 10,
			);
			$client     = new \BetterLinksPro\Dependencies\GuzzleHttp\Client( $options );
			$response   = $client->request( 'GET', $url );
			$statusCode = intval( $response->getStatusCode() );
			return array(
				'status_code' => $statusCode,
			);
		} catch ( \BetterLinksPro\Dependencies\GuzzleHttp\Exception\RequestException $e ) {
			$err_message = $e->getMessage();
			return array(
				'status_code' => true,
				'err_type'    => 'GuzzleHttp_Exception_RequestException',
				'err_message' => $err_message,
			);
		} catch ( \Throwable $e ) {
			$err_message = $e->getMessage();
			return array(
				'status_code' => true,
				'err_type'    => 'Throwable',
				'err_message' => $err_message,
			);
		} catch ( \Exception $e ) {
			$err_message = $e->getMessage();
			return array(
				'status_code' => true,
				'err_type'    => 'Exception',
				'err_message' => $err_message,
			);
		}
	}
	public static function get_timestamp_from_string( $string ) {
		if ( $string === 'yearly' ) {
			return time() + YEAR_IN_SECONDS;
		} elseif ( $string === 'monthly' ) {
			return time() + MONTH_IN_SECONDS;
		} elseif ( $string === 'weekly' ) {
			return time() + WEEK_IN_SECONDS;
		} elseif ( $string === 'daily' ) {
			return time() + DAY_IN_SECONDS;
		}
		return time();
	}
	public static function calculate_schedule_timestamp( $scan_mode, $scan_day, $scan_time ) {
		$timestamp           = self::get_timestamp_from_string( $scan_mode );
		$daynum              = (int) date( 'w', strtotime( $scan_day ) );
		$todayWeekDayNumbeer = (int) date( 'w', time() );
		if ( $daynum < $todayWeekDayNumbeer ) {
			return $timestamp = strtotime( $scan_time . ' ' . $scan_day . ' next week', $timestamp );
		}
		$daynum    = abs( $daynum - $todayWeekDayNumbeer );
		$timestamp = strtotime( '+' . $daynum . ' days ' . $scan_time, $timestamp );
		return $timestamp;
	}
	public static function get_individual_link_analytics( $args ) {
		$ID   = isset( $args['id'] ) ? sanitize_text_field( $args['id'] ) : '';
		$from = self::sanitize_date( $args['from'] ) ? sanitize_text_field( $args['from'] ) : date( 'Y-m-d', strtotime( ' - 30 days' ) );
		$to   = self::sanitize_date( $args['to'] ) ? sanitize_text_field( $args['to'] ) : date( 'Y-m-d' );

		global $wpdb;
		$prefix  = $wpdb->prefix;
		$results = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT CLICKS.ID as
            click_ID, link_id, browser, created_at, referer, short_url, target_url, ip, {$prefix}betterlinks.link_title,
            (select count(id) from {$prefix}betterlinks_clicks where CLICKS.ip = {$prefix}betterlinks_clicks.ip group by ip) as IPCOUNT
            from {$prefix}betterlinks_clicks as CLICKS left join {$prefix}betterlinks on {$prefix}betterlinks.id = CLICKS.link_id WHERE created_at BETWEEN %s AND %s AND {$prefix}betterlinks.id = %d group by CLICKS.id ORDER BY CLICKS.created_at DESC",
				$from . ' 00:00:00',
				$to . ' 23:59:00',
				$ID
			),
			ARRAY_A
		);
		return $results;
	}
	public static function get_split_test_analytics_data( $args ) {
		$ID                   = isset( $args['id'] ) ? $args['id'] : '';
		$split_analytics_meta = \BetterLinks\Helper::get_link_meta( $ID, 'split_test_analytics' );

		if ( ! empty( $split_analytics_meta ) ) {
			return $split_analytics_meta;
		}
		global $wpdb;
		$prefix  = $wpdb->prefix;
		$results = $wpdb->get_results(
			$wpdb->prepare( "SELECT cr.target_url as url, COUNT(cr.target_url) as clicks, COUNT(DISTINCT cl.visitor_id) as uniques, (select COUNT(DISTINCT {$prefix}betterlinks_clicks.visitor_id) from {$prefix}betterlinks_clicks where {$prefix}betterlinks_clicks.referer = cr.target_url) as conversions  FROM {$prefix}betterlinks_clicks cl JOIN {$prefix}betterlinks_clicks_rotations cr ON cl.id=cr.click_id WHERE cl.link_id=%d GROUP BY cr.target_url", $ID ),
			ARRAY_A
		);
		return $results;
	}
	public static function get_individual_clicks_count( $id ) {
		global $wpdb;
		$query = "SELECT COUNT(*) FROM {$wpdb->prefix}betterlinks_clicks where link_id=%d";
		$query = $wpdb->prepare( $query, array( $id ) );

		return (int) $wpdb->get_var( $query );
	}
	public static function get_individual_unique_clicks_count( $id ) {
		global $wpdb;
		$query = "SELECT COUNT(*) FROM (SELECT ip FROM `{$wpdb->prefix}betterlinks_clicks` WHERE `link_id`=%d group by ip) as unique_clicks";
		$query = $wpdb->prepare( $query, array( $id ) );

		return (int) $wpdb->get_var( $query );
	}

	public static function insert_click_rotation( $args ) {
		global $wpdb;
		$defaults = apply_filters(
			'betterlinkspro/insert_click_rotation_args',
			array(
				'link_id'    => '',
				'click_id'   => '',
				'target_url' => '',
			)
		);
		$args     = wp_parse_args( $args, $defaults );
		$wpdb->query(
			$wpdb->prepare(
				"INSERT INTO {$wpdb->prefix}betterlinks_clicks_rotations (
                        link_id,click_id,target_url
                    ) VALUES ( %d, %d, %s )",
				array(
					$args['link_id'],
					$args['click_id'],
					$args['target_url'],
				)
			)
		);
		return $wpdb->insert_id;
	}
	public static function get_all_clicks_rotations() {
		global $wpdb;
		$rotations = $wpdb->get_results(
			"SELECT * FROM {$wpdb->prefix}betterlinks_clicks_rotations",
			ARRAY_A
		);
		return $rotations;
	}
	public static function get_prettylinks_meta( $id, $meta_key ) {
		global $wpdb;
		$wpdb_prefix = $wpdb->prefix;
		$results     = $wpdb->get_results( $wpdb->prepare( "SELECT meta_key, meta_value from {$wpdb_prefix}prli_link_metas where meta_key=%s AND link_id = %d", $meta_key, $id ), OBJECT );
		return $results;
	}

	public static function insert_new_category( $slug ) {
		if ( ! ! intval( $slug ) ) {
			return $slug;
		}

		$is_cat_exists = \BetterLinks\Helper::term_exists( $slug );
		if ( ! $is_cat_exists ) {
			$insert_id = \BetterLinks\Helper::insert_term(
				array(
					'term_name' => $slug,
					'term_slug' => \BetterLinks\Helper::make_slug( $slug ),
					'term_type' => 'category',
				)
			);
			if ( $insert_id ) {
				\BetterLinks\Helper::clear_query_cache();
				$slug = $insert_id;
			}
		}
		return $slug;
	}

	public static function get_password_by_link_id( $link_id ) {
		global $wpdb;
		$query_string    = "SELECT `id`,`status` FROM {$wpdb->prefix}betterlinks_password where `link_id`=%d";
		$query_value_arr = array( $link_id );
		$result          = $wpdb->get_results( $wpdb->prepare( $query_string, $query_value_arr ) );
		return $result;
	}

	public static function check_password( $password, $link_id ) {
		global $wpdb;
		$query_string    = "SELECT `password` FROM {$wpdb->prefix}betterlinks_password where `link_id`=%d";
		$query_value_arr = array( $link_id );
		$result          = $wpdb->get_var( $wpdb->prepare( $query_string, $query_value_arr ) );

		return $result === $password;
	}

	public static function check_is_visitor_allowed_in_password_protection( $link_id ) {
		global $wpdb;
		$query_string    = "SELECT `allow_contact` FROM {$wpdb->prefix}betterlinks_password where `link_id`=%d";
		$query_value_arr = array( $link_id );
		$result          = $wpdb->get_var( $wpdb->prepare( $query_string, $query_value_arr ) );

		return $result === '1';
	}

	private function get_page_title_for_slug( $page_slug ) {
		$page = get_page_by_path( $page_slug, OBJECT );
		if ( $page ) {
			return true;
		}
		return false;
	}
	public function delete_custom_page( $page_slug ) {
		$page = get_page_by_path( $page_slug, OBJECT );
		if ( $page ) {
			wp_delete_post( $page->ID, true );
		}
		return;
	}
	public function add_password_protect_page() {
		if ( $this->get_page_title_for_slug( 'password-protected-form' ) ) {
			return false;
		}
		// Define the page title and content
		$page_title   = 'Password Protected Form';
		$page_content = '';
		$pageGuid     = site_url() . '/password-protected-form';

		// Create an array of page data
		$page_data = array(
			'post_title'   => $page_title,
			'post_content' => $page_content,
			'post_status'  => 'publish', // 'publish', 'draft', etc.
			'post_type'    => 'page',
			'guid'         => $pageGuid,
		);

		// Insert the page into the database
		$page_id = wp_insert_post( $page_data, false );

		if ( ! is_wp_error( $page_id ) ) {
			$password_template = BETTERLINKS_PRO_ROOT_DIR_PATH . 'includes/Admin/views/password-protect-form.php';
			update_post_meta( $page_id, '_wp_page_template', $password_template );
		}
	}

	public function add_customized_meta_tag_page() {
		if ( $this->get_page_title_for_slug( 'customized-meta-tags' ) ) {
			return false;
		}
		// Define the page title and content
		$page_title   = 'Customized Meta Tags';
		$page_content = '';
		$pageGuid     = site_url() . '/customized-meta-tags';

		// Create an array of page data
		$page_data = array(
			'post_title'   => $page_title,
			'post_content' => $page_content,
			'post_status'  => 'publish', // 'publish', 'draft', etc.
			'post_type'    => 'page',
			'guid'         => $pageGuid,
		);

		// Insert the page into the database
		$page_id = wp_insert_post( $page_data, false );

		if ( ! is_wp_error( $page_id ) ) {
			$password_template = BETTERLINKS_PRO_ROOT_DIR_PATH . 'includes/Admin/views/customized-meta-tags.php';
			update_post_meta( $page_id, '_wp_page_template', $password_template );
		}
	}

	private static function get_transient_key( $key, $from, $to, $id = null ) {
		$transient_key = str_replace( '-', '_', $from ) . '_' . str_replace( '-', '_', $to );
		if ( $id ) {
			$transient_key .= '_' . $id;
		}
		return $key . $transient_key;
	}
	/**
	 * @param string $from timestamp from
	 * @param string $to timestamp to
	 * @return array top 5 referer by clicks
	 */
	public static function get_top_referer( $from, $to ) {
		$transient_key = self::get_transient_key( 'btl_top_referer_', $from, $to );
		if ( $results = get_transient( $transient_key ) ) {
			return $results;
		}
		global $wpdb;
		$query = $wpdb->prepare(
			"select clicks.domain, count(clicks.domain) as clicks from 
        (select SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTRING_INDEX(referer, '/', 3), '/', -1), '.', -2) AS domain from {$wpdb->prefix}betterlinks_clicks where created_at between %s and %s and referer!='') as clicks 
            group by  domain 
            order by clicks desc limit 5;",
			$from . ' 00:00:00',
			$to . ' 23:59:59'
		);

		$results = $wpdb->get_results( $query, ARRAY_A );
		set_transient( $transient_key, $results, self::$transient_timeout );
		return $results;
	}

	/**
	 * @param string $from
	 * @param string $to
	 * @return array top device by clicks
	 */
	public static function get_device_click_stats( $from, $to ) {
		$transient_key = self::get_transient_key( 'btl_click_stats_', $from, $to );
		if ( $results = get_transient( $transient_key ) ) {
			return $results;
		}

		global $wpdb;
		$query = $wpdb->prepare(
			"select clicks.device, count(clicks.device) as clicks from 
        (select device from {$wpdb->prefix}betterlinks_clicks where created_at between %s and %s and device!='') as clicks 
            group by device 
            order by clicks desc limit 5;",
			$from . ' 00:00:00',
			$to . ' 23:59:59'
		);

		$results = $wpdb->get_results( $query, ARRAY_A );
		set_transient( $transient_key, $results, self::$transient_timeout );
		return $results;
	}

	/**
	 * @param string $from - timestate from
	 * @param string $to - timestate to
	 *
	 * @return array top os by clicks
	 */
	public static function get_top_os( $from, $to ) {
		$transient_key = self::get_transient_key( 'btl_top_os_', $from, $to );
		if ( $results = get_transient( $transient_key ) ) {
			return $results;
		}

		global $wpdb;
		$query = $wpdb->prepare(
			"select clicks.os,clicks.os_version, count(clicks.os) as clicks from 
        (select os,os_version from {$wpdb->prefix}betterlinks_clicks where created_at between %s and %s and os!='') as clicks 
            group by os,os_version  
            order by clicks desc limit 5;",
			$from . ' 00:00:00',
			$to . ' 23:59:59'
		);

		$results = $wpdb->get_results( $query, ARRAY_A );
		set_transient( $transient_key, $results, self::$transient_timeout );
		return $results;
	}


	public static function prepare_browser_data( $from, $to ) {

		$data = self::get_top_browser( $from, $to );

		$browsers = array(
			'chrome',
			'firefox',
			'safari',
			'edge',
			'opera',
			'internet explorer',
			'brave',
			'vivaldi',
			'tor browser',
			'microsoft edge',
			'uc browser',
			'yandex browser',
			'maxthon',
			'pale moon',
			'seamonkey',
			'midori',
			'avant browser',
			'epic privacy browser',
			'comodo dragon',
			'srware iron',
			'waterfox',
			'slimjet',
			'qutebrowser',
			'falkon',
			'gnome web (epiphany)',
			'otter browser',
			'konqueror',
			'lynx',
			'links',
			'dillo',
			'midori',
			'basilisk',
			'cyberfox',
			'dooble',
			'gnu icecat',
			'otter browser',
			'qutebrowser',
			'falkon',
			'luakit',
			'min',
			'surf',
			'vimb',
			'icab',
			'netscape navigator',
			'aol desktop',
			'sleipnir',
			'uc browser',
			'maxthon',
		);

		$browser_data = array();
		$others       = 0;
		foreach ( $data as $item ) {
			if ( in_array( strtolower( $item['browser'] ), $browsers ) ) {
				array_push( $browser_data, $item );
				continue;
			}
			$others += (int) $item['clicks'];
		}

		array_push(
			$browser_data,
			array(
				'browser'         => 'Others',
				'browser_version' => null,
				'clicks'          => $others,
			)
		);

		return $browser_data;
	}
	/**
	 * @param string $from - timestate from
	 * @param string $to - timestate to
	 *
	 * @return array top browser by clicks
	 */
	public static function get_top_browser( $from, $to ) {
		$transient_key = self::get_transient_key( 'btl_top_browser_', $from, $to );
		if ( $results = get_transient( $transient_key ) ) {
			return $results;
		}

		global $wpdb;
		$query = "select clicks.browser,clicks.browser_version, count(clicks.browser) as clicks from 
        (select SUBSTRING_INDEX(SUBSTRING_INDEX(browser, ' ', -2), '/', 1) as browser,browser_version from {$wpdb->prefix}betterlinks_clicks where created_at between '{$from} 00:00:00' and '{$to} 23:59:00' and browser!='') as clicks 
            group by browser,browser_version  
            order by clicks desc limit 5;";

		$results = $wpdb->get_results( $query, ARRAY_A );
		set_transient( $transient_key, $results, self::$transient_timeout );
		return $results;
	}

	public static function get_top_medium( $clicks ) {
		$social_domain    = array();
		$search_domain    = array();
		$ecommerce_domain = array();
		$others           = 0;

		$social_media  = array( 'facebook', 'twitter', 'linkedin', 'instagram', 'tiktok', 'youtube', 'pinterest', 'reddit', 'tumblr' );
		$search_engine = array( 'google', 'bing', 'duckduckgo', 'yahoo', 'baidu', 'yandex', 'startpage', 'ecosia', 'ask', 'naver' );
		$ecommerce     = array( 'amazon', 'ebay', 'walmart', 'alibaba', 'aliexpress', 'rakuten', 'wildberries', 'ozon', 'flipcart' );

		for ( $i = 0; $i < count( $clicks ); $i++ ) {
			$element = $clicks[ $i ];
			$referer = $element['referer_strip'];
			$count   = intval( $element['referer_count'] );
			if ( empty( $referer ) ) {
				continue;
			}

			$url          = parse_url( $referer );
			$host         = isset( $url['host'] ) ? $url['host'] : '';
			$hostSegments = explode( '.', $host );
			$host         = count( $hostSegments ) > 1 ? $hostSegments[ count( $hostSegments ) - 2 ] : $hostSegments[0];

			if ( empty( $host ) ) {
				continue;
			}

			if ( in_array( $host, $social_media ) ) {
				$social_domain[ $host ] = $count;
			} elseif ( in_array( $host, $search_engine ) ) {
				$search_domain[ $host ] = $count;
			} elseif ( in_array( $host, $ecommerce ) ) {
				$ecommerce_domain[ $host ] = $count;
			} else {
				$others += 1;
			}
		}
		$result = array(
			'social'    => $social_domain,
			'search'    => $search_domain,
			'ecommerce' => $ecommerce_domain,
			'others'    => $others,
		);
		return $result;
	}

	public static function get_all_referer( $from, $to ) {
		$transient_key = self::get_transient_key( 'btl_all_referer_', $from, $to );
		if ( $results = get_transient( $transient_key ) ) {
			return $results;
		}

		global $wpdb;

		$query = $wpdb->prepare(
			"SELECT SUBSTRING_INDEX(SUBSTRING_INDEX(referer, '/', 3), '//', -2) as referer_strip, count(*) as referer_count FROM {$wpdb->prefix}betterlinks_clicks WHERE referer!='' and created_at between %s and %s group by referer_strip",
			$from . ' 00:00:00',
			$to . ' 23:59:59'
		);

		$results = $wpdb->get_results( $query, ARRAY_A );
		set_transient( $transient_key, $results, self::$transient_timeout );
		return $results;
	}

	public static function get_meta_tag_by_link_id( $link_id ) {
		global $wpdb;
		$query   = "SELECT `meta_title`, `meta_desc`,`meta_image`, `status` from {$wpdb->prefix}betterlinks_meta_tags where `link_id`=%d";
		$results = $wpdb->get_results( $wpdb->prepare( $query, $link_id ) );

		return $results;
	}

	public static function get_meta_tags_by_short_url( $short_url ) {
		global $wpdb;
		$query   = "SELECT clicks.*,target_url as meta_url from {$wpdb->prefix}betterlinks_meta_tags as clicks 
			RIGHT JOIN (SELECT `id`,`target_url`
				FROM `{$wpdb->prefix}betterlinks` 
			WHERE short_url=%s LIMIT 1) AS link ON link.id=clicks.link_id";
		$results = $wpdb->get_row( $wpdb->prepare( $query, $short_url ), ARRAY_A );
		return $results;
	}

	public static function check_meta_tag_enable_by_link_id( $link_id ) {
		global $wpdb;
		$query   = "SELECT `status` FROM {$wpdb->prefix}betterlinks_meta_tags WHERE link_id=%d";
		$results = $wpdb->get_var( $wpdb->prepare( $query, $link_id ) );
		return $results;
	}

	/**
	 * Returns individual analytics graph data within a time limit
	 *
	 * @param int|string $id Clicks id.
	 * @param string     $from The start time.
	 * @param string     $to The end time.
	 *
	 * @return array Array of individual analytics graph clicks.
	 */
	public static function get_individual_graph_data( $id, $from, $to ) {
		$transient_key = self::get_transient_key( 'btl_individual_graph_data_', $from, $to, $id );
		if ( $results = get_transient( $transient_key ) ) {
			return $results;
		}
		global $wpdb;
		$query         = "SELECT count(ip) as uniq_count, T1.c_date from ( SELECT ip, DATE( created_at ) as c_date FROM {$wpdb->prefix}betterlinks_clicks 
        WHERE link_id={$id} and created_at  BETWEEN '{$from} 00:00:00' AND '{$to} 23:59:59' GROUP BY `ip`, `c_date` ) as T1 GROUP BY T1.c_date ORDER BY T1.c_date DESC";
		$unique_clicks = $wpdb->get_results( $query, ARRAY_A );

		$query        = "SELECT count(id) as click_count, DATE(created_at) as c_date FROM {$wpdb->prefix}betterlinks_clicks 
        WHERE link_id={$id} and created_at  BETWEEN '{$from} 00:00:00' AND '{$to} 23:59:59' GROUP BY c_date ORDER BY c_date DESC";
		$total_clicks = $wpdb->get_results( $query, ARRAY_A );

		$results = array(
			'total_count'  => $total_clicks,
			'unique_count' => $unique_clicks,
		);
		set_transient( $transient_key, $results, self::$transient_timeout );
		return $results;
	}

	public static function update_custom_script_data( $link_id, $arg ) {
		$custom_tracking_scripts = \BetterLinks\Helper::get_link_meta( $link_id, 'btl_custom_tracking_scripts' );
		$is_enable_scripts       = isset( $arg['enable_custom_scripts'] ) ? $arg['enable_custom_scripts'] : false;

		if ( ! empty( $custom_tracking_scripts ) ) {
			$custom_tracking_scripts = unserialize( $custom_tracking_scripts );
		}
		$custom_script = serialize(
			array(
				'enable' => $is_enable_scripts,
				'script' => isset( $arg['custom_tracking_scripts'] ) ? $arg['custom_tracking_scripts'] : '',
			)
		);
		if ( $is_enable_scripts ) {
			if ( empty( $custom_tracking_scripts ) ) {
				\BetterLinks\Helper::add_link_meta( $link_id, 'btl_custom_tracking_scripts', $custom_script );
			} else {
				\BetterLinks\Helper::update_link_meta( $link_id, 'btl_custom_tracking_scripts', $custom_script );
			}
		} elseif ( isset( $custom_tracking_scripts['enable'] ) && $custom_tracking_scripts['enable'] !== $is_enable_scripts ) {
			\BetterLinks\Helper::update_link_meta( $link_id, 'btl_custom_tracking_scripts', $custom_script );
		}
	}

	public static function parse_url( $url ) {
		if ( empty( $url ) ) {
			return false;
		}
		if ( is_array( $url ) ) {
			return wp_parse_url( $url[0] );
		}
		return wp_parse_url( $url );
	}

	public static function get_url_component( $parsed_url, $component = 'host' ) {
		if ( ! is_array( $parsed_url ) ) {
			return false;
		}
		return ! empty( $parsed_url[ $component ] ) ? $parsed_url[ $component ] : false;
	}

	public static function split_test_enabled( $data ) {
		$extra  = null;
		$id     = null;
		$helper = new \BetterLinks\Helper();
		if ( 'string' === gettype( $data ) ) {
			$id               = $data;
			$dynamic_redirect = $helper::get_link_data_by_id( $id, 'dynamic_redirect' );

			$split_test_data_meta = $helper::get_link_meta( $id, 'split_test_data' );

			if ( ! empty( $split_test_data_meta ) ) {
				$split_test_data_meta              = (array) $split_test_data_meta;
				$split_test_data_meta['completed'] = true;
				return $split_test_data_meta;
			}

			if ( is_string( $dynamic_redirect ) ) {
				$dynamic_redirect = json_decode( $dynamic_redirect );
			}
			$extra = isset( $dynamic_redirect->extra ) ? (array) $dynamic_redirect->extra : null;
		} else {
			$id                   = $data['ID'];
			$split_test_data_meta = $helper::get_link_meta( $id, 'split_test_data' );
			if ( ! empty( $split_test_data_meta ) ) {
				$split_test_data_meta              = (array) $split_test_data_meta;
				$split_test_data_meta['completed'] = true;
				return $split_test_data_meta;
			}
			$extra = isset( $data['dynamic_redirect'], $data['dynamic_redirect']['extra'] ) ? $data['dynamic_redirect']['extra'] : null;
		}
		if ( empty( $extra ) ) {
			return false;
		}

		$is_enable = isset( $extra['split_test'] ) ? '1' === $extra['split_test'] : false;

		if ( ! $is_enable ) {
			return false;
		}

		$is_expire_enable = isset( $extra['expire_split'] ) ? '1' === $extra['expire_split'] : false;

		if ( $is_enable && ! $is_expire_enable ) {
			return array( 'result' => true );
		}

		$expire_metrics      = isset( $extra['expire_split_after'] ) ? $extra['expire_split_after'] : 'clicks';
		$expire_split_clicks = isset( $extra['expire_split_clicks'] ) ? (int) $extra['expire_split_clicks'] : 0;
		$clicks_count        = null;

		if ( class_exists( '\BetterLinksPro\Helper' ) ) {
			$pro_helper = new \BetterLinksPro\Helper();

			if ( 'clicks' === $expire_metrics ) {
				$clicks_count = $pro_helper::get_individual_clicks_count( $id );
			} elseif ( 'unique_clicks' === $expire_metrics ) {
				$clicks_count = $pro_helper::get_individual_unique_clicks_count( $id );
			}
		}

		$result = $clicks_count < $expire_split_clicks;
		return array(
			'result'              => $result,
			'expire_metrics'      => $expire_metrics,
			'expire_split_clicks' => $expire_split_clicks,
			'clicks_count'        => $clicks_count,
			'completed'           => ! ( $clicks_count < ( $expire_split_clicks - 1 ) ),
		);
	}

	/**
	 * @param boolean $remember_cookies - remember cookies setting enabled or not
	 * @param integer $id - id of the short link
	 *
	 * @return boolean - returns true if password is okay, and cookie is valid, otherwise returns false
	 */
	public function passsword_cookie_enabled( $remember_cookies, $id ) {
		$cookie_name = "betterlinks_pass_protect_{$id}";
		if ( ! empty( $remember_cookies ) && isset( $_COOKIE[ $cookie_name ] ) ) {
			$result = self::check_password( $_COOKIE[ $cookie_name ], $id );
			return $result;
		}
		return false;
	}

	/**
	 * @param string $request_uri - REQUEST_URI.
	 *
	 * @return boolean - returns true if the request uri is self site url
	 */
	protected function is_self_url( $request_uri ) {
		// if the referer url is password-protected-form page, then return false.
		if ( str_contains( $request_uri, 'password-protected-form?short_url' ) ) {
			return false;
		}
		$is_self_url = url_to_postid( $request_uri );
		return ! empty( $is_self_url );
	}

	/**
	 * @param string $request_uri REQUEST_URI.
	 *
	 * @return string Short URL
	 */
	public function get_protected_self_url_short_link( $request_uri ) {
		global $wpdb;
		$is_self_url = $this->is_self_url( $request_uri );
		if ( empty( $is_self_url ) ) {
			return false;
		}

		$sql = "SELECT l.short_url FROM {$wpdb->prefix}betterlinks AS l 
                LEFT JOIN {$wpdb->prefix}betterlinks_password as p 
                    on l.ID=p.link_id 
                where l.target_url='{$request_uri}' and p.status='1';";

		$short_url = $wpdb->get_var( $sql ); // phpcs:ignore
		return $short_url;
	}

	public function referer_short_url( $referer ) {
		if ( empty( $referer ) ) {
			return false;
		}
		$password_param = explode( '?short_url=', $referer );
		if ( count( $password_param ) > 1 ) {
			return $password_param[1];
		}
		return false;
	}
	
	public static function get_all_post_types() {
		$public_post_types = get_post_types([
			'public'   => true,
		]);
		$builtin_post_types = get_post_types([
			'_builtin'   => false,
		]);
	
		return array_merge(  $public_post_types,$builtin_post_types );
	}
	private function sanitize_date( $date ){
		if( empty( $date ) ){
			return false;
		}
		$date = sanitize_text_field( $date );
		return strtotime( $date );
	}
}
