<?php
namespace BetterLinksPro\Analytics;

class GoogleAnalytics {
	private $visitor = null;

	public function __construct( $visitor ) {
		$this->visitor = $visitor;
	}

		// Generate UUID
		// Special thanks to stumiller.me for this formula.
	public function gaGenerateUUID() {
		return sprintf(
			'%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
			mt_rand( 0, 0xffff ),
			mt_rand( 0, 0xffff ),
			mt_rand( 0, 0xffff ),
			mt_rand( 0, 0x0fff ) | 0x4000,
			mt_rand( 0, 0x3fff ) | 0x8000,
			mt_rand( 0, 0xffff ),
			mt_rand( 0, 0xffff ),
			mt_rand( 0, 0xffff )
		);
	}

		// Send Data to Google Analytics UA
		// https://developers.google.com/analytics/devguides/collection/protocol/v1/devguide#event
	public function legacyGaSendData( $data ) {
		$getString  = 'https://ssl.google-analytics.com/collect';
		$getString .= '?payload_data&';
		$getString .= http_build_query( $data );
		$result     = wp_remote_get( $getString );
		return $result;
	}

		// Send Data to Google Analytics 4
		// https://firebase.google.com/codelabs/firebase_mp#4
		// https://ga-dev-tools.google/ga4/event-builder/
	public function ga4SendData( $data ) {
		$api_secret     = ! empty( $data['ga4_api_secret'] ) ? $data['ga4_api_secret'] : false;
		$measurement_id = ! empty( $data['tid'] ) ? $data['tid'] : '';

		if ( ! $api_secret || empty( $measurement_id ) ) {
			return;
		}

		$hostname = ! empty( $data['dh'] ) ? $data['dh'] : '';
		$page     = ! empty( $data['dp'] ) ? $data['dp'] : '';
		$title    = ! empty( $data['dt'] ) ? $data['dt'] : '';

		$endpoint = 'https://www.google-analytics.com/mp/collect?api_secret=' . $api_secret . '&measurement_id=' . $measurement_id;

		$data = array(
			'client_id' => $this->visitor,
			'events'    => array(
				array(
					'name'   => 'page_view',
					'params' => array(
						'page_title'           => $title,
						'page_location'        => $hostname . $page,
						'engagement_time_msec' => 1,
					),
				),
			),
		);

		$result = wp_remote_post(
			$endpoint,
			array(
				'body'    => wp_json_encode( $data ),
				'headers' => array(
					'Content-Type' => 'application/json',
				),
			)
		);

		return $result;
	}

	public function gaSendData( $data ) {
		if ( substr( $data['tid'], 0, 1 ) == 'U' ) {
			$this->legacyGaSendData( $data );
		} elseif ( substr( $data['tid'], 0, 1 ) == 'G' ) {
			$this->ga4SendData( $data );
		}
		return;
	}

		// Send Pageview Function for Server-Side Google Analytics
	public function ga_send_pageview( $tid, $ga4_api_secret, $hostname = null, $page = null, $title = null ) {
		if ( empty( $tid ) ) {
			return;
		}

		$data = array(
			'v'              => 1,
			'tid'            => $tid, // @TODO: Change this to your Google Analytics Tracking/Measurement ID.
			'ga4_api_secret' => $ga4_api_secret,  // @TODO: Change this to your Google Analytics 4 API Secret.
			'cid'            => $this->visitor,
			't'              => 'page_view',
			'dh'             => $hostname, // Document Hostname "example.com"
			'dp'             => $page, // Page "/something"
			'dt'             => $title, // Title
		);

		$this->gaSendData( $data );
	}
}
