<?php
namespace BetterLinksPro\Admin;

class Notices {
    public static function init(){
        $self = new self();

        add_action('admin_notices', array($self, 'install_core_notice'));
        add_action('wp_ajax_betterlinkspro/admin/install_core_installer', [$self, 'install_core_installer']);
        add_action( 'in_plugin_update_message-betterlinks-pro/betterlinks-pro.php' , [$self, 'on_plugin_update_message'], 11 );
    }
    public function install_core_notice()
    {
        if(did_action('betterlinks_loaded') === 1) return;
        $has_installed = get_plugins();
        $button_text = isset( $has_installed['betterlinks/betterlinks.php'] ) ? __( 'Activate Now!', 'betterlinks-pro' ) : __( 'Install Now!', 'betterlinks-pro' );
        ?>
        <div class="error notice is-dismissible">
			<p><?php echo sprintf( '<strong>%1$s</strong> %2$s <strong>%3$s</strong> %4$s', __( 'BetterLinks Pro', 'betterlinks-pro' ), __( 'requires', 'betterlinks-pro' ), __( 'BetterLinks', 'betterlinks-pro' ), __( 'core plugin to be installed. Please get the plugin now!', 'betterlinks-pro' ) ) ?> <button id="betterlinks-install-core" class="button button-primary"><?php echo $button_text; ?></button></p>
		</div>
        <script type="text/javascript">
            jQuery(document).ready( function($) {
                $('#betterlinks-install-core').on('click', function (e) {
                    var self = $(this);
                    e.preventDefault();
                    self.addClass('install-now updating-message');
                    self.text('<?php echo esc_js( 'Installing...' ); ?>');

                    $.ajax({
                        url: '<?php echo admin_url( 'admin-ajax.php' ); ?>',
                        type: 'post',
                        data: {
                            action: 'betterlinkspro/admin/install_core_installer',
                            _wpnonce: '<?php echo wp_create_nonce('betterlinks_pro_install_core_installer'); ?>',
                        },
                        success: function(response) {
                            self.text('<?php echo esc_js( 'Installed' ); ?>');
                            window.location.href = '<?php echo admin_url( 'admin.php?page=betterlinks' ); ?>';
                        },
                        error: function(error) {
                            self.removeClass('install-now updating-message');
                            alert( error?.message || __('Something went wrong', 'betterlinks-pro') );
                        },
                        complete: function() {
                            self.attr('disabled', 'disabled');
                            self.removeClass('install-now updating-message');
                        }
                    });
                });
            } );
        </script>
        <?php
    }

    public function install_core_installer()
    {
        check_ajax_referer('betterlinks_pro_install_core_installer', '_wpnonce');
        if( ! current_user_can( 'manage_options' ) ) wp_die();
        $has_installed = get_plugins();
        if(isset( $has_installed['betterlinks/betterlinks.php'] )){
            $result = activate_plugin('betterlinks/betterlinks.php', '', false );
            if (is_wp_error($result)) {
                wp_send_json_error($result->get_error_message());
            }
            if ($result === false) {
                wp_send_json_error(__('Plugin couldn\'t be activated.', 'betterlinks-pro'));
            }
            wp_send_json_success(__('BetterLinks is activated!', 'betterlinks-pro'));
            wp_die();
        }

        $result = self::install_plugin('betterlinks');
        if (is_wp_error($result)) {
            wp_send_json_error($result->get_error_message());
        }
        wp_send_json_success(__('Plugin is installed successfully!', 'betterlinks-pro'));
        wp_die();
    }

    public function on_plugin_update_message($args){
        // 
    }
    
    public static function get_remote_plugin_data( $slug = '' ) {
		if ( empty( $slug ) ) {
			return new \WP_Error( 'empty_arg', __( 'Argument should not be empty.' ) );
		}

		$response = wp_remote_post(
			'http://api.wordpress.org/plugins/info/1.0/',
			array(
				'body' => array(
					'action'  => 'plugin_information',
					'request' => serialize(
						(object) array(
							'slug'   => $slug,
							'fields' => array(
								'version' => false,
							),
						)
					),
				),
			)
		);

		if ( is_wp_error( $response ) ) {
			return $response;
		}

		return unserialize( wp_remote_retrieve_body( $response ) );
	}

	public static function install_plugin( $slug = '', $active = true ) {
		if ( empty( $slug ) ) {
			return new \WP_Error( 'empty_arg', __( 'Argument should not be empty.' ) );
		}

		include_once ABSPATH . 'wp-admin/includes/file.php';
		include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
		include_once ABSPATH . 'wp-admin/includes/class-automatic-upgrader-skin.php';

		$plugin_data = self::get_remote_plugin_data( $slug );

		if ( is_wp_error( $plugin_data ) ) {
			return $plugin_data;
		}

		$upgrader = new \Plugin_Upgrader( new \Automatic_Upgrader_Skin() );

		// install plugin
		$install = $upgrader->install( $plugin_data->download_link );

		if ( is_wp_error( $install ) ) {
			return $install;
		}

		// activate plugin
		if ( $install === true && $active ) {
			$active = activate_plugin( $upgrader->plugin_info(), '', false );

			if ( is_wp_error( $active ) ) {
				return $active;
			}

			return $active === null;
		}

		return $install;
	}
}