<?php
// @-collapse
namespace BetterLinksPro\Admin;

use BetterLinks\Cron;
use BetterLinksPro\Helper;

class Ajax {

	use \BetterLinksPro\Traits\BrokenLinks;
	use \BetterLinksPro\Traits\Keywords;

	public static function init() {
		$self = new self();
		add_action( 'wp_ajax_betterlinkspro/admin/get_role_management', array( $self, 'get_role_management' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/role_management', array( $self, 'role_management' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/get_external_analytics', array( $self, 'get_external_analytics' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/external_analytics', array( $self, 'external_analytics' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/analytics', array( $self, 'analytics' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/get_auto_link_create_settings', array( $self, 'get_auto_link_create_settings' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/set_auto_link_create_settings', array( $self, 'set_auto_link_create_settings' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/get_auto_link_disable_ids', array( $self, 'get_auto_link_disable_ids' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/set_auto_link_disable_ids', array( $self, 'set_auto_link_disable_ids' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/get_links', array( $self, 'get_links' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/get_broken_links_data', array( $self, 'get_broken_links_data' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/run_instant_broken_link_checker', array( $self, 'run_instant_broken_link_checker' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/delete_broken_link_checker_logs', array( $self, 'delete_broken_link_checker_logs' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/run_broken_links_checker', array( $self, 'run_broken_links_checker' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/run_single_broken_link_checker', array( $self, 'run_single_broken_link_checker' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/update_broken_link', array( $self, 'update_broken_link' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/remove_broken_link', array( $self, 'remove_broken_link' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/remove_multi_broken_link', array( $self, 'remove_multi_broken_link' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/get_broken_link_settings', array( $self, 'get_broken_link_settings' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/save_broken_link_settings', array( $self, 'save_broken_link_settings' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/get_split_test_analytics', array( $self, 'get_split_test_analytics' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/get_reporting_settings', array( $self, 'get_reporting_settings' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/saved_reporting_settings', array( $self, 'saved_reporting_settings' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/test_report_mail', array( $self, 'test_report_mail' ) );
		// filter
		add_filter( 'betterlinks/admin/current_user_can_edit_settings', array( $self, 'current_user_can_edit_settings' ) );
		add_filter( 'betterlinkspro/admin/current_user_can_edit_settings', array( $self, 'current_user_can_edit_settings' ) );
		// API Fallbck Ajax
		add_action( 'wp_ajax_betterlinks/admin/get_all_keywords', array( $self, 'get_all_keywords' ) );
		add_action( 'wp_ajax_betterlinks/admin/create_keyword', array( $self, 'create_keyword' ) );
		add_action( 'wp_ajax_betterlinks/admin/update_keyword', array( $self, 'update_keyword' ) );
		add_action( 'wp_ajax_betterlinks/admin/delete_keyword', array( $self, 'delete_keyword' ) );

		// Password Protection requests
		add_action( 'wp_ajax_betterlinkspro/admin/create_links_password', array( $self, 'create_links_password' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/fetch_links_password', array( $self, 'fetch_links_password' ) );

		// Customize Meta Tags
		add_action( 'wp_ajax_betterlinkspro/admin/fetch_meta_tags', array( $self, 'fetch_meta_tags' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/add_meta_tags', array( $self, 'add_meta_tags' ) );
		
		// Full site link scanner 
		add_action( 'wp_ajax_betterlinkspro/admin/get_full_site_links', array( $self, 'get_full_site_links' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/get_all_used_links_in_post_by_id', array( $self, 'get_all_used_links_in_post_by_id' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/clear_fullsite_broken_links', array( $self, 'clear_fullsite_broken_links' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/run_broken_link_checker', array( $self, 'run_broken_link_checker' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/get_fullsite_broken_link_settings', array( $self, 'get_fullsite_broken_link_settings' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/save_fullsite_broken_link_settings', array( $self, 'save_fullsite_broken_link_settings' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/run_single_link_checker', array( $self, 'run_single_link_checker' ) );
		add_action( 'wp_ajax_betterlinkspro/admin/remove_single_scan_log', array( $self, 'remove_single_scan_log' ) );

		// Custom Short Domain
		add_action( 'wp_ajax_betterlinkspro/admin/check_custom_domain_dns', array( $self, 'check_custom_domain_dns' ) );
	}

	public function check_custom_domain_dns() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this" );
		}

		$custom_domain = isset( $_POST['url'] ) ? sanitize_url( $_POST['url'] ) : '';

		$headers = @get_headers( $custom_domain, true );

		$location       = isset( $headers['Location'] ) ? $headers['Location'] : ( isset( $headers['location'] ) ? $headers['location'] : '' );
		$parse_location = Helper::parse_url( $location );
		$location_host  = Helper::get_url_component( $parse_location, 'host' );

		$parse_site_url = Helper::parse_url( site_url() );
		$site_url_host  = Helper::get_url_component( $parse_site_url, 'host' );

		// $site_ip = (isset( $_SERVER['SERVER_ADDR'] ) && filter_var( $_SERVER['SERVER_ADDR'], FILTER_VALIDATE_IP )) ? sanitize_text_field( $_SERVER['SERVER_ADDR'] ) : ( null !== gethostbyname(site_url()) && filter_var( gethostbyname(site_url()), FILTER_VALIDATE_IP ) ? gethostbyname(site_url()) : false);

		$site_ip = null !== gethostbyname( $site_url_host ) && filter_var( gethostbyname( $site_url_host ), FILTER_VALIDATE_IP ) ? gethostbyname( $site_url_host ) : false;

		$site_ip = ! empty( $site_ip ) ? $site_ip : ( ( isset( $_SERVER['SERVER_ADDR'] ) && filter_var( $_SERVER['SERVER_ADDR'], FILTER_VALIDATE_IP ) ) ? sanitize_text_field( $_SERVER['SERVER_ADDR'] ) : false );

		wp_send_json_error(
			array(
				'result'  => $location_host === $site_url_host,
				'site_ip' => $site_ip,
			),
		);
	}

	public function get_fullsite_broken_link_settings() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$results = get_option( BETTERLINKS_PRO_FULLSITE_BROKEN_LINK_OPTION_NAME, '{}' );
		
		$post_types = Helper::get_all_post_types();
		unset( $post_types['attachment'] );
		$post_types = array_merge(array('all' => 'all'), $post_types);
		
		wp_send_json_success( array(
			'settings' => $results,
			'post_types' => $post_types
		) );
	}

	public function save_fullsite_broken_link_settings() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$data = \BetterLinks\Helper::fresh_ajax_request_data( $_POST );
		$data = \BetterLinks\Helper::sanitize_text_or_array_field( $data );
		$data = wp_json_encode( $data );
		update_option( BETTERLINKS_PRO_FULLSITE_BROKEN_LINK_OPTION_NAME, $data );
		delete_option(BETTERLINKS_PRO_FULLSITE_BROKEN_LINK_LOGS);
		wp_send_json_success( $data );
	}

	public function run_single_link_checker() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}

		$row_link = isset( $_POST['row_link'] ) ? $_POST['row_link'] : '';
		if( empty( $row_link ) ) {
			wp_send_json_error([
				'status_code' => false,
			], 404);
		}
		$status     = Helper::url_http_response_is_broken( $row_link );
		wp_send_json_success($status, 200);
	}

	public function remove_single_scan_log() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}

		$link = isset( $_POST['link'] ) ? $_POST['link'] : '';
		$post_link = isset( $_POST['post_link'] ) ? $_POST['post_link'] : '';
		$status = isset( $_POST['status'] ) ? $_POST['status'] : '';
		if( empty( $post_link ) || empty( $link ) ) {
			wp_send_json_error([
				'result' => false,
			], 404);
		}
		$post_id = url_to_postid($post_link);
		$fullsite_broken_link_logs = get_option('betterlinkspro_fullsite_broken_links_logs', []);
		if( is_string( $fullsite_broken_link_logs ) ){
			$fullsite_broken_link_logs = json_decode( $fullsite_broken_link_logs, true );
		}
		
		$fullsite_broken_link_logs[$post_id][$link]['status'] = $status;
		update_option('betterlinkspro_fullsite_broken_links_logs', json_encode( $fullsite_broken_link_logs ));
		wp_send_json_success([
			'updated_list' => $fullsite_broken_link_logs 
		], 200);
	}

	public function run_broken_link_checker() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this" );
		}
		
		$link = isset( $_POST['link'] ) ? $_POST['link'] : '';
		$id = isset( $_POST['id'] ) ? $_POST['id'] : null;
		$details = !empty( $_POST['details'] ) ? stripslashes($_POST['details']) : '';

		$details = json_decode( $details, true );

		$logs       = json_decode( get_option( BETTERLINKS_PRO_FULLSITE_BROKEN_LINK_LOGS, '{}' ), true );

		$http_args = array(
			'connect_timeout' => 10,
			'timeout' => 5
		);
		// $status = Helper::url_http_response_is_broken( $link, $http_args );
		$response = wp_remote_get( $link, array( 'timeout' => 5, 'sslverify' => false, 'httpversion' => '1.1' ) );
        $code = wp_remote_retrieve_response_code( $response );
		$status = ['status_code' => $code];
		// error_log( print_r( $status['status_code'], true ) );
		$details['status'] = (!empty( $status['status_code'] ) && intval($status['status_code']) >= 100) ? $status['status_code'] : 404;
		// $details['status'] = $status['status_code'] == 1 ? 200 : $status['status_code'];
		$details['status'] = intval( $details['status']  ) >= 400 ? 404 : $details['status'];
		$logs[$id][$link] = $details;
		
		update_option( BETTERLINKS_PRO_FULLSITE_BROKEN_LINK_LOGS, json_encode( $logs ), true  );
		wp_send_json_success(array(
			'status' =>$details['status']
		));
	}

	public function clear_fullsite_broken_links() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this" );
		}

		delete_option(BETTERLINKS_PRO_FULLSITE_BROKEN_LINK_LOGS);
		update_option( 'betterlinkspro_fullsite_broken_links_logs_cleared', 1 );
		wp_send_json(array(
			'success' => true,
		));
	}

	public function get_all_used_links_in_post_by_id() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this" );
		}

		$id = isset( $_POST['ID'] ) ? intval( $_POST['ID'] ) : null;
		// $isResume = isset( $_POST['isResume'] ) ?  $_POST['isResume']  : null;
		$post = get_post( $id );
		if( is_wp_error( $post ) ) {
			wp_send_json_error(array(
				'message' => 'Post not found',
				'result' => false,
			));
		}

		$post_content = !empty( $post->post_content ) ? $post->post_content : 'nothing';

		$doc = new \DomDocument();

		@$doc->loadHTML( $post_content );

		$links = $doc->getElementsByTagName( 'a' );
		
		$extracted_links = [];

		foreach ($links as $i){
			// $link = wp_http_validate_url($i->getAttribute( 'href' ));
			$link = !empty( $i->getAttribute( 'href' ) ) ? $i->getAttribute( 'href' ) : '';
			if( strpos( $link, '#' ) === 0 ) {
				continue;
			}
			if( empty( $link  ) ) continue;
			
			$linkText = $i->textContent;
			$extracted_links[$link] = [
				'innerText' => $linkText,
				'post_type' => $post->post_type
			];
        }

		if( empty( $extracted_links ) ){
			$logs       = json_decode( get_option( BETTERLINKS_PRO_FULLSITE_BROKEN_LINK_LOGS, '{}' ), true );
			$logs[$id] = [];
			update_option( BETTERLINKS_PRO_FULLSITE_BROKEN_LINK_LOGS, json_encode( $logs ), false  );
		}

		update_option('betterlinks_pro_fullsite_last_scaned_post', json_encode( [
			$id => count( $extracted_links )
		] ));
		
		wp_send_json_success(array(
			'post_links' => array(
				$id => $extracted_links
			),
			'result' => true,
		));
	}

	public function fullsite_scanner_allowed_post_type() {
		$fullsite_scan_settings = get_option(BETTERLINKS_PRO_FULLSITE_BROKEN_LINK_OPTION_NAME, '{}');
		$fullsite_scan_settings = json_decode( $fullsite_scan_settings, true );
		$post_types = isset( $fullsite_scan_settings['fullsite_scanner_post_types'] ) ? $fullsite_scan_settings['fullsite_scanner_post_types'] : '';
		$post_types = explode( "|", $post_types );
		
		$allowed_post_type = [];
		if( in_array('all**all', $post_types) ){
			$all_post_types = Helper::get_all_post_types();
			unset( $all_post_types['attachment'] );
			return $all_post_types;
		}
		foreach ($post_types as $value) {
			$post_type = explode( '**', $value );
			array_push( $allowed_post_type, $post_type[0] );
		  }
		return $allowed_post_type;
	}
	public function get_full_site_links() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this" );
		}

		$allowed_post_type = $this->fullsite_scanner_allowed_post_type();

		$post_types = get_post_types([
            // 'public'   => true,
        ]);

		$posts = get_posts([
            'post_type' => $post_types,
            'numberposts' => -1,
            'post_status' => array('publish', 'pending', 'draft', 'future', 'private', 'inherit'),
        ]);



		$post_links = [];
		foreach ($posts as $post) {
			if( !empty( $allowed_post_type ) && !in_array( $post->post_type, $allowed_post_type ) ) continue;
			$post_links[$post->ID] = array(
				'permalink' => get_permalink($post->ID),
				'name' => !empty($post->post_title) ? $post->post_title : $post->post_name,
				'edit_link' => get_edit_post_link($post->ID, ''),
				'post_type' => $post->post_type
			);
		}

		$logs       = json_decode( get_option( BETTERLINKS_PRO_FULLSITE_BROKEN_LINK_LOGS, '{}' ), true );
		
		if( !empty( $allowed_post_type ) ){
			foreach( $logs as $log_key => $log_value ) {
				foreach( $log_value as $key => $value ){
					if(!in_array( $value['post_type'], $allowed_post_type ) ){
						unset( $logs[$log_key][$key] );
					}
				}
			}
		}
		 // removing last log to ensure all links are being scanned after  resume;
		 $post_keys = array_keys( $post_links );
		 $last_post_key = isset( $post_keys[0] ) ? $post_keys[0] : '';
		 
		 $log_keys = array_keys( $logs );
		$last_log_key = count($log_keys) > 0 ? $log_keys[count($log_keys)-1] : "";
		$last_logs = !empty( $last_log_key ) ? $logs[$last_log_key] : []; 
		
		$last_scaned_post = get_option( 'betterlinks_pro_fullsite_last_scaned_post', '{}' );
		$last_scaned_post = json_decode( $last_scaned_post, true );


		$is_completed = isset( $last_scaned_post[$last_log_key] ) && $last_scaned_post[$last_log_key] == count( $last_logs );

		// if( count($log_keys) > 0 && count( $log_keys ) < count( $post_keys ) ){
		if( (count($log_keys) > 0 && $last_post_key !== $last_log_key) && !$is_completed ){
			unset( $logs[$last_log_key] );
		}

		wp_send_json_success(
			array(
				'logs'  => $logs,
				'post_links' => $post_links,
				'last_scaned_status' => $is_completed
			)
		);
	}

	public function fetch_meta_tags() {
		$nonce             = isset( $_POST['security'] ) ? sanitize_text_field( wp_unslash( $_POST['security'] ) ) : '';
		$betterlinks_nonce = 'betterlinks_admin_nonce';
		if ( ! wp_verify_nonce( $nonce, $betterlinks_nonce ) ) {
			wp_die( "You don't have permission to do this" );
		}

		if ( ! apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this" );
		}

		global $wpdb;
		$query   = "SELECT * FROM {$wpdb->prefix}betterlinks_meta_tags";
		$results = $wpdb->get_results( $query, ARRAY_A );
		wp_send_json_success(
			array(
				'data' => $results,
			),
			200
		);
	}


	public function fetch_links_password() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this" );
		}
		global $wpdb;
		$query_string = "SELECT * FROM {$wpdb->prefix}betterlinks_password";
		$results      = $wpdb->get_results( $query_string );

		wp_send_json_success(
			array(
				'links' => $results,
			),
			200
		);
	}

	public function add_meta_tags() {
		$nonce             = isset( $_POST['security'] ) ? sanitize_text_field( wp_unslash( $_POST['security'] ) ) : '';
		$betterlinks_nonce = 'betterlinks_admin_nonce';
		if ( ! wp_verify_nonce( $nonce, $betterlinks_nonce ) ) {
			wp_die( "You don't have permission to do this" );
		}

		if ( ! apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this" );
		}

		global $wpdb;
		$status           = isset( $_POST['status'] ) ? 'true' === $_POST['status'] : 0;
		$link_id          = ! empty( $_POST['link_id'] ) ? sanitize_text_field( wp_unslash( $_POST['link_id'] ) ) : null;
		$meta_title       = ! empty( $_POST['meta_title'] ) ? sanitize_text_field( wp_unslash( $_POST['meta_title'] ) ) : '';
		$meta_description = ! empty( $_POST['meta_description'] ) ? sanitize_text_field( wp_unslash( $_POST['meta_description'] ) ) : '';
		$meta_image       = ! empty( $_POST['meta_image'] ) ? sanitize_url( wp_unslash( $_POST['meta_image'] ) ) : '';

		// check if the meta tags already added
		$result = Helper::get_meta_tag_by_link_id( $link_id );

		if ( 1 === count( $result ) ) {
			$update_query = "UPDATE {$wpdb->prefix}betterlinks_meta_tags set meta_title=%s, meta_desc=%s,meta_image=%s,status=%d where link_id=%d";

			$update_query_values = array( $meta_title, $meta_description, $meta_image, $status, $link_id );

			$update = $wpdb->query( $wpdb->prepare( $update_query, $update_query_values ) );
			wp_send_json(
				array(
					'updated' => $update ? true : false,
					'message' => $update ? 'Updated successfully' : 'Failed to update',
				),
				$update ? 200 : 500
			);
		}

		$query_string    = "INSERT INTO {$wpdb->prefix}betterlinks_meta_tags (`link_id`, `meta_title`, `meta_desc`, `meta_image`, `status`) VALUES(%d,%s,%s,%s,%d)";
		$query_value_arr = array( $link_id, $meta_title, $meta_description, $meta_image, $status );

		$wpdb->query( $wpdb->prepare( $query_string, $query_value_arr ) );

		if ( $wpdb->insert_id ) {
			wp_send_json_success(
				array(
					'success' => true,
					'message' => 'meta tags inserted successfully.',
					'data'    => array(
						'id'         => $wpdb->insert_id,
						'link_id'    => $link_id,
						'meta_title' => $meta_title,
						'meta_desc'  => $meta_description,
						'meta_image' => $meta_image,
					),
				),
				201
			);
		} else {
			wp_send_json_error(
				array(
					'success' => false,
					'message' => 'Something went wrong.',
				),
				500
			);
		}
	}
	public function create_links_password() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );

		if ( ! apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this" );
		}
		global $wpdb;
		$link_id       = ! empty( $_POST['link_id'] ) ? $_POST['link_id'] : null;
		$password      = ! empty( $_POST['password'] ) ? $_POST['password'] : '';
		$status        = ( isset( $_POST['status'] ) && 'true' === $_POST['status'] );
		$allow_contact = ( isset( $_POST['allow_contact'] ) && 'true' === $_POST['allow_contact'] );

		// 👇 check if the link password is already exists using link_id
		$result = Helper::get_password_by_link_id( $link_id );

		if ( count( $result ) === 1 ) { // if result returns true, that means link password already exists
			$update_query        = "UPDATE {$wpdb->prefix}betterlinks_password SET `status`=%d, `password`=%s, `allow_contact`=%d WHERE `link_id`=%d";
			$update_query_values = array( $status, $password, $allow_contact, $link_id );

			$update = $wpdb->query( $wpdb->prepare( $update_query, $update_query_values ) );
			wp_send_json(
				array(
					'updated' => $update ? true : false,
					'message' => $update ? 'Updated successfully' : 'Failed to update',
				),
				$update ? 200 : 500
			);
		}
		// completed update query

		$query_string    = "INSERT INTO {$wpdb->prefix}betterlinks_password (`link_id`, `password`, `status`, `allow_contact`) VALUES(%d,%s,%d,%d)";
		$query_value_arr = array( $link_id, $password, $status, $allow_contact );

		$wpdb->query( $wpdb->prepare( $query_string, $query_value_arr ) );

		if ( $wpdb->insert_id ) {
			wp_send_json_success(
				array(
					'success' => true,
					'message' => 'password created successfully.',
					'data'    => array(
						'id'            => $wpdb->insert_id,
						'link_id'       => $link_id,
						'status'        => $status,
						'allow_contact' => $allow_contact,
					),
				),
				201
			);
		} else {
			wp_send_json_error(
				array(
					'success' => false,
					'message' => 'Something went wrong.',
				),
				500
			);
		}
	}


	public function get_role_management() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			$data = get_option( BETTERLINKS_PRO_ROLE_PERMISSON_OPTION_NAME, '{}' );
			wp_send_json_success( json_decode( $data, true ) );
		}
		wp_die( "You don't have permission to do this." );
	}
	public function role_management() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			return false;
		}
		$viewlinks      = ( isset( $_POST['viewlinks'] ) ? explode( ',', sanitize_text_field( $_POST['viewlinks'] ) ) : array() );
		$writelinks     = ( isset( $_POST['writelinks'] ) ? explode( ',', sanitize_text_field( $_POST['writelinks'] ) ) : array() );
		$editlinks      = ( isset( $_POST['editlinks'] ) ? explode( ',', sanitize_text_field( $_POST['editlinks'] ) ) : array() );
		$checkanalytics = ( isset( $_POST['checkanalytics'] ) ? explode( ',', sanitize_text_field( $_POST['checkanalytics'] ) ) : array() );
		$editsettings   = ( isset( $_POST['editsettings'] ) ? explode( ',', sanitize_text_field( $_POST['editsettings'] ) ) : array() );
		$editFavorite   = ( isset( $_POST['editFavorite'] ) ? explode( ',', sanitize_text_field( $_POST['editFavorite'] ) ) : array() );
		$manageAutoliks = ( isset( $_POST['manageAutoliks'] ) ? explode( ',', sanitize_text_field( $_POST['manageAutoliks'] ) ) : array() );
		$update         = update_option(
			BETTERLINKS_PRO_ROLE_PERMISSON_OPTION_NAME,
			wp_json_encode(
				array(
					'viewlinks'      => $viewlinks,
					'writelinks'     => $writelinks,
					'editlinks'      => $editlinks,
					'checkanalytics' => $checkanalytics,
					'editsettings'   => $editsettings,
					'editFavorite'   => $editFavorite,
					'manageAutoliks' => $manageAutoliks,
				)
			)
		);
		wp_send_json_success( $update );
	}

	public function get_external_analytics() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			$data = get_option( BETTERLINKS_PRO_EXTERNAL_ANALYTICS_OPTION_NAME, array() );
			if ( is_string( $data ) ) {
				$data = json_decode( $data, true );
			}
			wp_send_json_success( $data );
		}
		wp_die( "You don't have permission to do this." );
	}

	public function get_auto_link_create_settings() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			$data = get_option( BETTERLINKS_PRO_AUTO_LINK_CREATE_OPTION_NAME, array() );
			if ( is_string( $data ) ) {
				$data = json_decode( $data, true );
			}
			wp_send_json_success( $data );
		}
		wp_die( "You don't have permission to do this." );
	}

	public function get_auto_link_disable_ids() {
		check_ajax_referer( 'betterlinks_admin_nonce', 'security' );
		if ( apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			$post_id = ( isset( $_POST['id'] ) ? intval( sanitize_text_field( $_POST['id'] ) ) : '' );
			$data    = get_post_meta( $post_id, BETTERLINKS_PRO_AUTO_LINK_DISABLE_IDS );
			wp_send_json_success( $data );
		}
		wp_die( "You don't have permission to do this." );
	}
	public function set_auto_link_disable_ids() {
		check_ajax_referer( 'betterlinks_admin_nonce', 'security' );
		if ( apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			$post_id = ( isset( $_POST['id'] ) ? intval( sanitize_text_field( $_POST['id'] ) ) : '' );
			$status  = ( isset( $_POST['status'] ) ? sanitize_text_field( $_POST['status'] ) : '0' );
			$data    = get_post_meta( $post_id, BETTERLINKS_PRO_AUTO_LINK_DISABLE_IDS );

			$update = update_post_meta( $post_id, BETTERLINKS_PRO_AUTO_LINK_DISABLE_IDS, $status );

			wp_send_json( $update );
		}
		wp_die( "You don't have permission to do this." );
	}

	public function external_analytics() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			$is_enable_ga = filter_var( ( isset( $_POST['is_enable_ga'] ) ? sanitize_text_field( $_POST['is_enable_ga'] ) : false ), FILTER_VALIDATE_BOOLEAN );
			// $is_ga4 = filter _var( ( is set( $ _ POST['i s_ga4'] ) ? sanit ize_ text_field( $ _ POST['is_ga4'] ) : fal se ), FILTER_V ALIDATE_B OOLEAN );
			$is_ga4                   = true; // Since Universal analytics has stopped tracking, so we only have GA4.
			$is_enable_pixel          = filter_var( ( isset( $_POST['is_enable_pixel'] ) ? sanitize_text_field( $_POST['is_enable_pixel'] ) : false ), FILTER_VALIDATE_BOOLEAN );
			$ga_tracking_code         = ( isset( $_POST['ga_tracking_code'] ) ? sanitize_text_field( $_POST['ga_tracking_code'] ) : '' );
			$ga4_api_secret           = ( isset( $_POST['ga4_api_secret'] ) ? sanitize_text_field( $_POST['ga4_api_secret'] ) : '' );
			$pixel_id                 = ( isset( $_POST['pixel_id'] ) ? sanitize_text_field( $_POST['pixel_id'] ) : '' );
			$pixel_access_token       = ( isset( $_POST['pixel_access_token'] ) ? sanitize_text_field( $_POST['pixel_access_token'] ) : '' );
			$is_enable_custom_scripts = filter_var( ( isset( $_POST['is_enable_custom_scripts'] ) ? sanitize_text_field( $_POST['is_enable_custom_scripts'] ) : false ), FILTER_VALIDATE_BOOLEAN );
			$global_head_scripts = ( isset( $_POST['global_head_scripts'] ) ?  $_POST['global_head_scripts'] : '' ); // phpcs:ignore
			$parameter_tracking = ( isset( $_POST['parameter_tracking'] ) ?  json_decode( stripslashes($_POST['parameter_tracking']), true )   : ''); // phpcs:ignore

			$analytic_data = array(
				'is_enable_ga'             => $is_enable_ga,
				'is_ga4'                   => $is_ga4,
				'ga_tracking_code'         => $ga_tracking_code,
				'ga4_api_secret'           => $ga4_api_secret,
				'is_enable_pixel'          => $is_enable_pixel,
				'pixel_id'                 => $pixel_id,
				'pixel_access_token'       => $pixel_access_token,
				'is_enable_custom_scripts' => $is_enable_custom_scripts,
				'global_head_scripts'      => $global_head_scripts,
				'parameter_tracking'       => $parameter_tracking,
			);
			$update        = update_option( BETTERLINKS_PRO_EXTERNAL_ANALYTICS_OPTION_NAME, $analytic_data );
			if ( defined( 'BETTERLINKS_EXISTS_LINKS_JSON' ) && BETTERLINKS_EXISTS_LINKS_JSON ) {
				$formattedArray = \BetterLinks\Helper::get_links_for_json();
				file_put_contents( BETTERLINKS_UPLOAD_DIR_PATH . '/links.json', wp_json_encode( $formattedArray ) );
			}
			wp_send_json_success( $update );
		}
		wp_die( "You don't have permission to do this." );
	}

	public function analytics() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			$Cron    = new Cron();
			$resutls = $Cron->analytics();
			wp_send_json_success( $resutls );
		}
		wp_die( "You don't have permission to do this." );
	}
	public function set_auto_link_create_settings() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( apply_filters( 'betterlinkspro/admin/current_user_can_edit_settings', current_user_can( 'manage_options' ) ) ) {
			$enable_auto_link = filter_var( ( isset( $_POST['enable_auto_link'] ) ? sanitize_text_field( $_POST['enable_auto_link'] ) : false ), FILTER_VALIDATE_BOOLEAN );
			$post_shortlinks  = filter_var( ( isset( $_POST['post_shortlinks'] ) ? sanitize_text_field( $_POST['post_shortlinks'] ) : false ), FILTER_VALIDATE_BOOLEAN );
			$page_shortlinks  = filter_var( ( isset( $_POST['page_shortlinks'] ) ? sanitize_text_field( $_POST['page_shortlinks'] ) : false ), FILTER_VALIDATE_BOOLEAN );
			$post_default_cat = ( isset( $_POST['post_default_cat'] ) ? sanitize_text_field( $_POST['post_default_cat'] ) : 0 );
			$page_default_cat = ( isset( $_POST['page_default_cat'] ) ? sanitize_text_field( $_POST['page_default_cat'] ) : 0 );

			$auto_link_create_options = array(
				'enable_auto_link' => $enable_auto_link,
				'post_shortlinks'  => $enable_auto_link ? $post_shortlinks : false,
				'page_shortlinks'  => $enable_auto_link ? $page_shortlinks : false,
			);

			if ( ! empty( $auto_link_create_options['post_shortlinks'] ) ) {
				$post_default_cat                             = Helper::insert_new_category( $post_default_cat );
				$auto_link_create_options['post_default_cat'] = $post_default_cat;
			}
			if ( ! empty( $auto_link_create_options['page_shortlinks'] ) ) {
				$page_default_cat                             = Helper::insert_new_category( $page_default_cat );
				$auto_link_create_options['page_default_cat'] = $page_default_cat;
			}

			$update = update_option( BETTERLINKS_PRO_AUTO_LINK_CREATE_OPTION_NAME, wp_json_encode( $auto_link_create_options ) );
			wp_send_json_success( $update );
		}
		wp_die( "You don't have permission to do this." );
	}

	public function get_links() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinks/api/links_get_items_permissions_check', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this." );
		}
		global $wpdb;
		$ID = ( isset( $_POST['ID'] ) ? sanitize_text_field( esc_sql( $_POST['ID'] ) ) : '' );
		if ( $ID ) {
			$results = $wpdb->get_results(
				$wpdb->prepare(
					"SELECT ID, link_title FROM {$wpdb->prefix}betterlinks WHERE ID=%d",
					$ID
				),
				OBJECT
			);
		} else {
			$results = $wpdb->get_results( "SELECT ID, link_title FROM {$wpdb->prefix}betterlinks", OBJECT );
		}
		wp_send_json_success( $results );
	}
	public function get_broken_links_data() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		global $wpdb;
		$results = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}betterlinks", OBJECT );
		$links   = wp_json_encode( $results );
		$logs    = get_option( 'betterlinkspro_broken_links_logs' );
		wp_send_json_success(
			array(
				'links' => $links,
				'logs'  => $logs,
			)
		);
	}
	public function run_instant_broken_link_checker() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		global $wpdb;
		$results = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}betterlinks", OBJECT );
		$links   = wp_json_encode( $results );
		$logs    = get_option( 'betterlinkspro_broken_links_logs' );
		wp_send_json_success(
			array(
				'links' => $links,
				'logs'  => $logs,
			)
		);
	}
	public function delete_broken_link_checker_logs() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$result = delete_option( 'betterlinkspro_broken_links_logs' );
		wp_send_json_success( $result );
	}
	public function run_broken_links_checker() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$data = \BetterLinks\Helper::fresh_ajax_request_data( $_POST );
		
		if ( is_array( $data ) && count( $data ) ) {
			$this->check_broken_link( $data );
		}
		wp_send_json_success( get_option( 'betterlinkspro_broken_links_logs' ) );
	}
	public function run_single_broken_link_checker() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}

		global $wpdb;
		$ID     = ( isset( $_REQUEST['ID'] ) ? sanitize_text_field( esc_sql( $_REQUEST['ID'] ) ) : 0 );
		$result = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM {$wpdb->prefix}betterlinks WHERE ID=%d",
				$ID
			),
			OBJECT
		);

		$result     = current( $result );
		$target_url = '';
		$target_url = Helper::addScheme( $result->target_url );
		$status     = Helper::url_http_response_is_broken( $target_url );
		if ( isset( $status['status_code'] ) ) {
			wp_send_json_success( $status );
		} else {
			wp_send_json_error( "status wasn't recieved" );
		}
	}

	public function update_broken_link() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		do_action( 'betterlinks/write_json_links' );
		$ID                     = ( isset( $_REQUEST['ID'] ) ? sanitize_text_field( $_REQUEST['ID'] ) : 0 );
		$target_url             = ( isset( $_REQUEST['target_url'] ) ? sanitize_text_field( $_REQUEST['target_url'] ) : 0 );
		$logs                   = json_decode( get_option( 'betterlinkspro_broken_links_logs' ), true );
		$log_item               = $logs[ $ID ];
		$log_item['target_url'] = $target_url;
		$logs[ $ID ]            = $log_item;
		update_option( 'betterlinkspro_broken_links_logs', wp_json_encode( $logs ), false );
		wp_send_json_success( wp_json_encode( $logs ) );
	}
	public function remove_broken_link() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$ID                               = ( isset( $_REQUEST['ID'] ) ? sanitize_text_field( $_REQUEST['ID'] ) : 0 );
		$results                          = json_decode( get_option( 'betterlinkspro_broken_links_logs' ), true );
		$results[ $ID ]['is_log_removed'] = true;
		update_option( 'betterlinkspro_broken_links_logs', wp_json_encode( $results ), false );
		wp_send_json_success( wp_json_encode( $results ) );
	}
	public function remove_multi_broken_link() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$logs    = \BetterLinks\Helper::fresh_ajax_request_data( $_REQUEST );
		$results = json_decode( get_option( 'betterlinkspro_broken_links_logs' ), true );
		foreach ( $logs as $ID ) {
			$results[ $ID ]['is_log_removed'] = true;
		}
		update_option( 'betterlinkspro_broken_links_logs', wp_json_encode( $results ), false );
		wp_send_json_success( wp_json_encode( $results ) );
	}


	public function current_user_can_edit_settings() {
		if ( current_user_can( 'manage_options' ) ) {
			return true;
		}
		$user               = wp_get_current_user();
		$user_permission    = json_decode( get_option( BETTERLINKS_PRO_ROLE_PERMISSON_OPTION_NAME ), true );
		$current_user_roles = current( $user->roles );
		if (
			in_array( $current_user_roles, $user_permission['editsettings'] )
		) {
			return true;
		}
		return false;
	}

	public function get_broken_link_settings() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$restuls = get_option( BETTERLINKS_PRO_BROKEN_LINK_OPTION_NAME, '{}' );
		wp_send_json_success( $restuls );
	}

	public function save_broken_link_settings() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$data = \BetterLinks\Helper::fresh_ajax_request_data( $_POST );
		$data = \BetterLinks\Helper::sanitize_text_or_array_field( $data );

		wp_clear_scheduled_hook( 'betterlinkspro/broken_link_checker' );
		update_option( BETTERLINKS_PRO_BROKEN_LINK_OPTION_NAME, wp_json_encode( $data ) );
		wp_send_json_success( wp_json_encode( $data ) );
	}
	public function get_split_test_analytics() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/api/analytics_items_permissions_check', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this." );
		}
		$ID      = ( isset( $_REQUEST['ID'] ) ? $_REQUEST['ID'] : '' );
		$results = Helper::get_split_test_analytics_data( array( 'id' => $ID ) );

		$split_test_data = Helper::split_test_enabled( $ID );

		wp_send_json_success(
			array(
				'results'         => $results,
				'split_test_data' => $split_test_data,
			),
			200
		);
	}
	public function get_reporting_settings() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$restuls = get_option( BETTERLINKS_PRO_REPORTING_OPTION_NAME, '{}' );
		wp_send_json_success(
			$restuls,
			200
		);
	}
	public function saved_reporting_settings() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$data = \BetterLinks\Helper::fresh_ajax_request_data( $_POST );
		$data = \BetterLinks\Helper::sanitize_text_or_array_field( $data );
		update_option( BETTERLINKS_PRO_REPORTING_OPTION_NAME, wp_json_encode( $data ) );
		wp_send_json_success(
			wp_json_encode( $data ),
			200
		);
	}
	public function test_report_mail() {
		check_ajax_referer( 'betterlinkspro_admin_nonce', 'security' );
		if ( ! $this->current_user_can_edit_settings() ) {
			wp_die( "You don't have permission to do this." );
		}
		$email = $this->send_mail();
		wp_send_json_success(
			$email,
			200
		);
	}
	public function get_all_keywords() {
		check_ajax_referer( 'betterlinks_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/api/manage_autolink_permission_check', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this." );
		}
		$results = \BetterLinks\Helper::get_keywords();
		wp_send_json_success(
			$results,
			200
		);
	}
	public function create_keyword() {
		check_ajax_referer( 'betterlinks_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/api/manage_autolink_permission_check', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this." );
		}
		$data    = \BetterLinks\Helper::fresh_ajax_request_data( $_POST );
		$item    = $this->prepare_keyword_item_for_db( $data );
		$link_id = ( isset( $item['link_id'] ) ? $item['link_id'] : 0 );
		\BetterLinks\Helper::add_link_meta( $link_id, 'keywords', $item );
		wp_send_json_success(
			$item,
			200
		);
	}
	public function update_keyword() {
		check_ajax_referer( 'betterlinks_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/api/manage_autolink_permission_check', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this." );
		}
		$data         = \BetterLinks\Helper::fresh_ajax_request_data( $_POST );
		$old_link_id  = absint( isset( $data['oldChooseLink'] ) ? $data['oldChooseLink'] : 0 );
		$link_id      = absint( isset( $data['chooseLink'] ) ? $data['chooseLink'] : 0 );
		$old_keywords = ( isset( $data['oldKeywords'] ) ? $data['oldKeywords'] : '' );
		$item         = $this->prepare_keyword_item_for_db( $data );
		$is_update    = \BetterLinks\Helper::update_link_meta( $link_id, 'keywords', $item, $old_keywords, $old_link_id );
		if ( $is_update ) {
			wp_send_json_success(
				array_merge(
					$item,
					array(
						'old_link_id'  => $old_link_id,
						'old_keywords' => $old_keywords,
					)
				),
				200
			);
		} else {
			wp_send_json_error( 'updated link meta failed ' );
		}
	}
	public function delete_keyword() {
		check_ajax_referer( 'betterlinks_admin_nonce', 'security' );
		if ( ! apply_filters( 'betterlinkspro/api/manage_autolink_permission_check', current_user_can( 'manage_options' ) ) ) {
			wp_die( "You don't have permission to do this." );
		}
		$id        = ( isset( $_POST['id'] ) ? intval( sanitize_text_field( $_POST['id'] ) ) : 0 );
		$keywords  = ( isset( $_POST['keywords'] ) ? ( sanitize_text_field( $_POST['keywords'] ) ) : '' );
		$is_delete = \BetterLinks\Helper::delete_link_meta( $id, 'keywords', '', $keywords );
		wp_send_json_success(
			$is_delete,
			200
		);
	}
}
